/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.Composer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.DigestUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMS;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSSignature;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.SeedDerive;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HSSPrivateKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final boolean isShard;
    private List<LMSPrivateKeyParameters> keys;
    private List<LMSSignature> sig;
    private final long indexLimit;
    private long index = 0L;
    private HSSPublicKeyParameters publicKey;

    public HSSPrivateKeyParameters(LMSPrivateKeyParameters lMSPrivateKeyParameters, long l, long l2) {
        super(true);
        this.l = 1;
        this.keys = Collections.singletonList(lMSPrivateKeyParameters);
        this.sig = Collections.emptyList();
        this.index = l;
        this.indexLimit = l2;
        this.isShard = false;
        this.resetKeyToIndex();
    }

    private HSSPrivateKeyParameters(int n, List<LMSPrivateKeyParameters> list, List<LMSSignature> list2, long l, long l2, boolean bl) {
        super(true);
        this.l = n;
        this.keys = Collections.unmodifiableList(list);
        this.sig = Collections.unmodifiableList(list2);
        this.index = l;
        this.indexLimit = l2;
        this.isShard = bl;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] byArray, byte[] byArray2) throws IOException {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(byArray);
        hSSPrivateKeyParameters.publicKey = HSSPublicKeyParameters.getInstance(byArray2);
        return hSSPrivateKeyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSPrivateKeyParameters getInstance(Object object) throws IOException {
        if (object instanceof HSSPrivateKeyParameters) {
            return (HSSPrivateKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            int n;
            if (((DataInputStream)object).readInt() != 0) {
                throw new IllegalStateException("unknown version for hss private key");
            }
            int n2 = ((DataInputStream)object).readInt();
            long l = ((DataInputStream)object).readLong();
            long l2 = ((DataInputStream)object).readLong();
            boolean bl = ((DataInputStream)object).readBoolean();
            ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>();
            ArrayList<LMSSignature> arrayList2 = new ArrayList<LMSSignature>();
            for (n = 0; n < n2; ++n) {
                arrayList.add(LMSPrivateKeyParameters.getInstance(object));
            }
            for (n = 0; n < n2 - 1; ++n) {
                arrayList2.add(LMSSignature.getInstance(object));
            }
            return new HSSPrivateKeyParameters(n2, arrayList, arrayList2, l, l2, bl);
        }
        if (object instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                try {
                    HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(inputStream);
                    return hSSPrivateKeyParameters;
                }
                catch (Exception exception) {
                    HSSPrivateKeyParameters hSSPrivateKeyParameters;
                    block14: {
                        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMSPrivateKeyParameters.getInstance(object);
                        hSSPrivateKeyParameters = new HSSPrivateKeyParameters(lMSPrivateKeyParameters, lMSPrivateKeyParameters.getIndex(), lMSPrivateKeyParameters.getIndexLimit());
                        if (inputStream == null) break block14;
                        inputStream.close();
                    }
                    return hSSPrivateKeyParameters;
                }
            }
        }
        if (object instanceof InputStream) {
            return HSSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public int getL() {
        return this.l;
    }

    public synchronized long getIndex() {
        return this.index;
    }

    private static HSSPrivateKeyParameters makeCopy(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(hSSPrivateKeyParameters.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHierarchy(LMSPrivateKeyParameters[] lMSPrivateKeyParametersArray, LMSSignature[] lMSSignatureArray) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            this.keys = Collections.unmodifiableList(java.util.Arrays.asList(lMSPrivateKeyParametersArray));
            this.sig = Collections.unmodifiableList(java.util.Arrays.asList(lMSSignatureArray));
        }
    }

    LMSPrivateKeyParameters getRootKey() {
        return this.keys.get(0);
    }

    synchronized List<LMSPrivateKeyParameters> getKeys() {
        return this.keys;
    }

    void resetKeyToIndex() {
        LMSPrivateKeyParameters[] lMSPrivateKeyParametersArray;
        int n;
        List<LMSPrivateKeyParameters> list = this.getKeys();
        long[] lArray = new long[list.size()];
        long l = this.getIndex();
        for (n = list.size() - 1; n >= 0; --n) {
            lMSPrivateKeyParametersArray = list.get(n).getSigParameters();
            int n2 = (1 << lMSPrivateKeyParametersArray.getH()) - 1;
            lArray[n] = l & (long)n2;
            l >>>= lMSPrivateKeyParametersArray.getH();
        }
        n = 0;
        lMSPrivateKeyParametersArray = list.toArray(new LMSPrivateKeyParameters[list.size()]);
        LMSSignature[] lMSSignatureArray = this.sig.toArray(new LMSSignature[this.sig.size()]);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this.getRootKey();
        if ((long)(lMSPrivateKeyParametersArray[0].getIndex() - 1) != lArray[0]) {
            lMSPrivateKeyParametersArray[0] = LMS.generateKeys(lMSPrivateKeyParameters.getSigParameters(), lMSPrivateKeyParameters.getOtsParameters(), (int)lArray[0], lMSPrivateKeyParameters.getI(), lMSPrivateKeyParameters.getMasterSecret());
            n = 1;
        }
        for (int i = 1; i < lArray.length; ++i) {
            boolean bl;
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = lMSPrivateKeyParametersArray[i - 1];
            int n3 = lMSPrivateKeyParameters2.getOtsParameters().getN();
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[n3];
            SeedDerive seedDerive = new SeedDerive(lMSPrivateKeyParameters2.getI(), lMSPrivateKeyParameters2.getMasterSecret(), DigestUtil.getDigest(lMSPrivateKeyParameters2.getOtsParameters()));
            seedDerive.setQ((int)lArray[i - 1]);
            seedDerive.setJ(-2);
            seedDerive.deriveSeed(byArray2, true);
            byte[] byArray3 = new byte[n3];
            seedDerive.deriveSeed(byArray3, false);
            System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
            boolean bl2 = i < lArray.length - 1 ? lArray[i] == (long)(lMSPrivateKeyParametersArray[i].getIndex() - 1) : lArray[i] == (long)lMSPrivateKeyParametersArray[i].getIndex();
            boolean bl3 = bl = Arrays.areEqual(byArray, lMSPrivateKeyParametersArray[i].getI()) && Arrays.areEqual(byArray2, lMSPrivateKeyParametersArray[i].getMasterSecret());
            if (!bl) {
                lMSPrivateKeyParametersArray[i] = LMS.generateKeys(list.get(i).getSigParameters(), list.get(i).getOtsParameters(), (int)lArray[i], byArray, byArray2);
                lMSSignatureArray[i - 1] = LMS.generateSign(lMSPrivateKeyParametersArray[i - 1], lMSPrivateKeyParametersArray[i].getPublicKey().toByteArray());
                n = 1;
                continue;
            }
            if (bl2) continue;
            lMSPrivateKeyParametersArray[i] = LMS.generateKeys(list.get(i).getSigParameters(), list.get(i).getOtsParameters(), (int)lArray[i], byArray, byArray2);
            n = 1;
        }
        if (n != 0) {
            this.updateHierarchy(lMSPrivateKeyParametersArray, lMSSignatureArray);
        }
    }

    public synchronized HSSPublicKeyParameters getPublicKey() {
        return new HSSPublicKeyParameters(this.l, this.getRootKey().getPublicKey());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)object;
        if (this.l != hSSPrivateKeyParameters.l) {
            return false;
        }
        if (this.isShard != hSSPrivateKeyParameters.isShard) {
            return false;
        }
        if (this.indexLimit != hSSPrivateKeyParameters.indexLimit) {
            return false;
        }
        if (this.index != hSSPrivateKeyParameters.index) {
            return false;
        }
        if (!this.keys.equals(hSSPrivateKeyParameters.keys)) {
            return false;
        }
        return this.sig.equals(hSSPrivateKeyParameters.sig);
    }

    @Override
    public synchronized byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose().u32str(0).u32str(this.l).u64str(this.index).u64str(this.indexLimit).bool(this.isShard);
        for (LMSPrivateKeyParameters encodable : this.keys) {
            composer.bytes(encodable);
        }
        for (LMSSignature lMSSignature : this.sig) {
            composer.bytes(lMSSignature);
        }
        return composer.build();
    }

    public int hashCode() {
        int n = this.l;
        n = 31 * n + (this.isShard ? 1 : 0);
        n = 31 * n + this.keys.hashCode();
        n = 31 * n + this.sig.hashCode();
        n = 31 * n + (int)(this.indexLimit ^ this.indexLimit >>> 32);
        n = 31 * n + (int)(this.index ^ this.index >>> 32);
        return n;
    }

    protected Object clone() throws CloneNotSupportedException {
        return HSSPrivateKeyParameters.makeCopy(this);
    }
}

