/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Integers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat {
    public static int add(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)(l += ((long)nArray[i] & 0xFFFFFFFFL) + ((long)nArray2[i] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        return (int)l;
    }

    public static int add33To(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        l >>>= 32;
        nArray[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) + 1L);
        return (l >>>= 32) == 0L ? 0 : Nat.incAt(n, nArray, 2);
    }

    public static int addBothTo(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)(l += ((long)nArray[i] & 0xFFFFFFFFL) + ((long)nArray2[i] & 0xFFFFFFFFL) + ((long)nArray3[i] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addTo(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = (int)(l += ((long)nArray[i] & 0xFFFFFFFFL) + ((long)nArray2[i] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addTo(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray2[n3 + i] = (int)(l += ((long)nArray[n2 + i] & 0xFFFFFFFFL) + ((long)nArray2[n3 + i] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addWordAt(int n, int n2, int[] nArray, int n3) {
        long l = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL);
        nArray[n3] = (int)l;
        return (l >>>= 32) == 0L ? 0 : Nat.incAt(n, nArray, n3 + 1);
    }

    public static int addWordTo(int n, int n2, int[] nArray) {
        long l = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        return (l >>>= 32) == 0L ? 0 : Nat.incAt(n, nArray, 1);
    }

    public static int cadd(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)(-(n2 & 1)) & 0xFFFFFFFFL;
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)(l2 += ((long)nArray[i] & 0xFFFFFFFFL) + ((long)nArray2[i] & l));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int caddTo(int n, int n2, int[] nArray, int[] nArray2) {
        long l = (long)(-(n2 & 1)) & 0xFFFFFFFFL;
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = (int)(l2 += ((long)nArray2[i] & 0xFFFFFFFFL) + ((long)nArray[i] & l));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static void copy(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        System.arraycopy(nArray, n2, nArray2, n3, n);
    }

    public static int[] create(int n) {
        return new int[n];
    }

    public static long[] create64(int n) {
        return new long[n];
    }

    public static int dec(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] - 1;
            if (nArray[n3] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int n, int[] nArray, int n2) {
        int n3 = n2;
        while (n3 < n) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] - 1;
            if (nArray[n4] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static boolean eq(int n, int[] nArray, int[] nArray2) {
        for (int i = n - 1; i >= 0; --i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(int n, BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > n) {
            throw new IllegalArgumentException();
        }
        int n2 = n + 31 >> 5;
        int[] nArray = Nat.create(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(int n, BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > n) {
            throw new IllegalArgumentException();
        }
        int n2 = n + 63 >> 6;
        long[] lArray = Nat.create64(n2);
        for (int i = 0; i < n2; ++i) {
            lArray[i] = bigInteger.longValue();
            bigInteger = bigInteger.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] nArray, int n) {
        if (n == 0) {
            return nArray[0] & 1;
        }
        int n2 = n >> 5;
        if (n2 < 0 || n2 >= nArray.length) {
            return 0;
        }
        int n3 = n & 0x1F;
        return nArray[n2] >>> n3 & 1;
    }

    public static int getBitLength(int n, int[] nArray) {
        for (int i = n - 1; i >= 0; --i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            return i * 32 + 32 - Integers.numberOfLeadingZeros(n2);
        }
        return 0;
    }

    public static boolean gte(int n, int[] nArray, int[] nArray2) {
        for (int i = n - 1; i >= 0; --i) {
            int n2 = nArray[i] ^ Integer.MIN_VALUE;
            int n3 = nArray2[i] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static int inc(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + 1;
            if (nArray[n3] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray2[i] = n2 = nArray[i] + 1;
            if (n2 == 0) continue;
            while (i < n) {
                nArray2[i] = nArray[i];
                ++i;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int n, int[] nArray, int n2) {
        int n3 = n2;
        while (n3 < n) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] + 1;
            if (nArray[n4] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int incAt(int n, int[] nArray, int n2, int n3) {
        for (int i = n3; i < n; ++i) {
            int n4 = n2 + i;
            nArray[n4] = nArray[n4] + 1;
            if (nArray[n4] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static boolean isOne(int n, int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int n, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static int lessThan(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += ((long)nArray[i] & 0xFFFFFFFFL) - ((long)nArray2[i] & 0xFFFFFFFFL);
            l >>= 32;
        }
        return (int)l;
    }

    public static int mul31BothAdd(int n, int n2, int[] nArray, int n3, int[] nArray2, int[] nArray3, int n4) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int n5 = 0;
        do {
            nArray3[n4 + n5] = (int)(l += l2 * ((long)nArray[n5] & 0xFFFFFFFFL) + l3 * ((long)nArray2[n5] & 0xFFFFFFFFL) + ((long)nArray3[n4 + n5] & 0xFFFFFFFFL));
            l >>>= 32;
        } while (++n5 < n);
        return (int)l;
    }

    public static int mulWordAddTo(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        int n5 = 0;
        do {
            nArray2[n4 + n5] = (int)(l += l2 * ((long)nArray[n3 + n5] & 0xFFFFFFFFL) + ((long)nArray2[n4 + n5] & 0xFFFFFFFFL));
            l >>>= 32;
        } while (++n5 < n);
        return (int)l;
    }

    public static int shiftDownBit(int n, int[] nArray, int n2) {
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = nArray[n3];
            nArray[n3] = n4 >>> 1 | n2 << 31;
            n2 = n4;
        }
        return n2 << 31;
    }

    public static int shiftDownBits(int n, int[] nArray, int n2, int n3, int n4, int[] nArray2, int n5) {
        int n6 = n;
        while (--n6 >= 0) {
            int n7 = nArray[n2 + n6];
            nArray2[n5 + n6] = n7 >>> n3 | n4 << -n3;
            n4 = n7;
        }
        return n4 << -n3;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            nArray2[i] = n3 << 1 | n2 >>> 31;
            n2 = n3;
        }
        return n2 >>> 31;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2, int n3, int[] nArray2, int n4) {
        for (int i = 0; i < n; ++i) {
            int n5 = nArray[n2 + i];
            nArray2[n4 + i] = n5 << 1 | n3 >>> 31;
            n3 = n5;
        }
        return n3 >>> 31;
    }

    public static long shiftUpBit64(int n, long[] lArray, int n2, long l, long[] lArray2, int n3) {
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[n2 + i];
            lArray2[n3 + i] = l2 << 1 | l >>> 63;
            l = l2;
        }
        return l >>> 63;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            nArray[i] = n4 << n2 | n3 >>> -n2;
            n3 = n4;
        }
        return n3 >>> -n2;
    }

    public static long shiftUpBits64(int n, long[] lArray, int n2, int n3, long l) {
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[n2 + i];
            lArray[n2 + i] = l2 << n3 | l >>> -n3;
            l = l2;
        }
        return l >>> -n3;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            nArray2[i] = n4 << n2 | n3 >>> -n2;
            n3 = n4;
        }
        return n3 >>> -n2;
    }

    public static long shiftUpBits64(int n, long[] lArray, int n2, int n3, long l, long[] lArray2, int n4) {
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[n2 + i];
            lArray2[n4 + i] = l2 << n3 | l >>> -n3;
            l = l2;
        }
        return l >>> -n3;
    }

    public static int sub(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = (int)(l += ((long)nArray[i] & 0xFFFFFFFFL) - ((long)nArray2[i] & 0xFFFFFFFFL));
            l >>= 32;
        }
        return (int)l;
    }

    public static int sub33From(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        l >>= 32;
        nArray[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) - 1L);
        return (l >>= 32) == 0L ? 0 : Nat.decAt(n, nArray, 2);
    }

    public static int subFrom(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = (int)(l += ((long)nArray2[i] & 0xFFFFFFFFL) - ((long)nArray[i] & 0xFFFFFFFFL));
            l >>= 32;
        }
        return (int)l;
    }

    public static int subFrom(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray2[n3 + i] = (int)(l += ((long)nArray2[n3 + i] & 0xFFFFFFFFL) - ((long)nArray[n2 + i] & 0xFFFFFFFFL));
            l >>= 32;
        }
        return (int)l;
    }

    public static int subWordFrom(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        return (l >>= 32) == 0L ? 0 : Nat.decAt(n, nArray, 1);
    }

    public static BigInteger toBigInteger(int n, int[] nArray) {
        byte[] byArray = new byte[n << 2];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, n - 1 - i << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int n, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
    }

    public static void zero64(int n, long[] lArray) {
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
        }
    }
}

