/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeIndex;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.List;

public class CompositePrivateKey
implements PrivateKey {
    private final List<PrivateKey> keys;
    private ASN1ObjectIdentifier algorithmIdentifier;

    public List<PrivateKey> getPrivateKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return CompositeIndex.getAlgorithmName(this.algorithmIdentifier);
    }

    public ASN1ObjectIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.algorithmIdentifier.equals(MiscObjectIdentifiers.id_composite_key)) {
            for (int i = 0; i < this.keys.size(); ++i) {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(this.keys.get(i).getEncoded());
                aSN1EncodableVector.add(privateKeyInfo);
            }
            try {
                return new PrivateKeyInfo(new AlgorithmIdentifier(this.algorithmIdentifier), new DERSequence(aSN1EncodableVector)).getEncoded("DER");
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to encode composite private key: " + iOException.getMessage());
            }
        }
        byte[] byArray = null;
        for (int i = 0; i < this.keys.size(); ++i) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(this.keys.get(i).getEncoded());
            byArray = Arrays.concatenate(byArray, privateKeyInfo.getPrivateKey().getOctets());
        }
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(this.algorithmIdentifier), byArray).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode composite private key: " + iOException.getMessage());
        }
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePrivateKey) {
            boolean bl = true;
            CompositePrivateKey compositePrivateKey = (CompositePrivateKey)object;
            if (!compositePrivateKey.getAlgorithmIdentifier().equals(this.algorithmIdentifier) || !this.keys.equals(compositePrivateKey.keys)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }
}

