/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERVideotexString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1VideotexString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1VideotexString.class, 21){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1VideotexString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    ASN1VideotexString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 21, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1VideotexString)) {
            return false;
        }
        ASN1VideotexString aSN1VideotexString = (ASN1VideotexString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1VideotexString.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    static ASN1VideotexString createPrimitive(byte[] byArray) {
        return new DERVideotexString(byArray, false);
    }
}

