/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Objects;
import io.opentelemetry.testing.internal.jackson.databind.BeanDescription;
import io.opentelemetry.testing.internal.jackson.databind.BeanProperty;
import java.lang.annotation.Annotation;

final class JacksonBeanFieldInfo
implements BeanFieldInfo {
    private final BeanDescription classBean;
    private final BeanProperty property;

    JacksonBeanFieldInfo(BeanDescription classBean, BeanProperty property) {
        this.classBean = java.util.Objects.requireNonNull(classBean, "classBean");
        this.property = java.util.Objects.requireNonNull(property, "property");
    }

    @Override
    public String name() {
        return this.property.getName();
    }

    @Override
    @Nullable
    public <T extends Annotation> T getFieldAnnotation(Class<T> annotationClass) {
        return this.property.getAnnotation(annotationClass);
    }

    @Override
    @Nullable
    public <T extends Annotation> T getClassAnnotation(Class<T> annotationClass) {
        return this.classBean.getClassAnnotations().get(annotationClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonBeanFieldInfo that = (JacksonBeanFieldInfo)o;
        return Objects.equal(this.classBean, that.classBean) && Objects.equal(this.property, that.property);
    }

    public int hashCode() {
        return Objects.hashCode(this.classBean, this.property);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("classBean", this.classBean).add("property", this.property).toString();
    }
}

