/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedResponse;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.BeanFieldMaskerCache;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.function.BiFunction;

final class AnnotatedResponseJsonSerializer
extends JsonSerializer<AnnotatedResponse> {
    private final BiFunction<BeanFieldInfo, Object, @Nullable Object> masker;

    AnnotatedResponseJsonSerializer(BeanFieldMaskerCache fieldMaskerCache) {
        this.masker = (info, o) -> fieldMaskerCache.fieldMasker((BeanFieldInfo)info).mask(o);
    }

    AnnotatedResponseJsonSerializer() {
        this.masker = (info, o) -> o;
    }

    @Override
    public Class<AnnotatedResponse> handledType() {
        return AnnotatedResponse.class;
    }

    @Override
    public void serialize(AnnotatedResponse value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("value");
        Object retValue = value.value();
        if (retValue == null) {
            gen.writeNull();
            gen.writeEndObject();
            return;
        }
        retValue = this.masker.apply(value.beanFieldInfo(), retValue);
        if (retValue == null) {
            gen.writeNull();
            gen.writeEndObject();
            return;
        }
        gen.writeObject(retValue);
        gen.writeEndObject();
    }
}

