/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedRequest;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.BeanFieldMaskerCache;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.function.BiFunction;

final class AnnotatedRequestJsonSerializer
extends JsonSerializer<AnnotatedRequest> {
    private final BiFunction<BeanFieldInfo, Object, @Nullable Object> masker;

    AnnotatedRequestJsonSerializer(BeanFieldMaskerCache fieldMaskerCache) {
        this.masker = (info, o) -> fieldMaskerCache.fieldMasker((BeanFieldInfo)info).mask(o);
    }

    AnnotatedRequestJsonSerializer() {
        this.masker = (info, o) -> o;
    }

    @Override
    public Class<AnnotatedRequest> handledType() {
        return AnnotatedRequest.class;
    }

    @Override
    public void serialize(AnnotatedRequest value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("params");
        gen.writeStartArray();
        for (int i = 0; i < value.rawParameters().size(); ++i) {
            Object parameter = value.getParameter(i);
            if (parameter == null) {
                gen.writeNull();
                continue;
            }
            BeanFieldInfo beanFieldInfo = value.beanFieldInfos().get(i);
            parameter = this.masker.apply(beanFieldInfo, parameter);
            if (parameter == null) {
                gen.writeNull();
                continue;
            }
            gen.writeObject(parameter);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

