/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceLogUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class AnnotatedRequest {
    private final List<@Nullable Object> rawParameters;
    private final List<BeanFieldInfo> beanFieldInfos;

    AnnotatedRequest(Object[] rawParameters, List<BeanFieldInfo> beanFieldInfos) {
        assert (rawParameters.length == beanFieldInfos.size());
        this.rawParameters = Collections.unmodifiableList(Arrays.asList(rawParameters));
        this.beanFieldInfos = beanFieldInfos;
    }

    List<@Nullable Object> rawParameters() {
        return this.rawParameters;
    }

    @Nullable
    Object getParameter(int index) {
        Object o = this.rawParameters.get(index);
        return AnnotatedServiceLogUtil.maybeUnwrapFuture(o);
    }

    List<BeanFieldInfo> beanFieldInfos() {
        return this.beanFieldInfos;
    }

    private List<Object> parameters() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (int i = 0; i < this.rawParameters.size(); ++i) {
            parameters.add(this.getParameter(i));
        }
        return parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("parameters", this.parameters()).toString();
    }
}

