/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ChannelUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.io.netty.channel.IoEventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandle;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandler;
import io.opentelemetry.testing.internal.io.netty.channel.IoHandlerFactory;
import io.opentelemetry.testing.internal.io.netty.channel.MultiThreadIoEventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.nio.NioIoHandle;
import io.opentelemetry.testing.internal.io.netty.channel.nio.NioIoHandler;
import io.opentelemetry.testing.internal.io.netty.channel.socket.DatagramChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.ServerSocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.SocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.nio.NioDatagramChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.nio.NioSocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.unix.ServerDomainSocketChannel;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;

public final class TransportTypeProvider {
    public static final TransportTypeProvider NIO = new TransportTypeProvider("NIO", NioServerSocketChannel.class, NioSocketChannel.class, null, null, NioDatagramChannel.class, NioIoHandle.class, (nThreads, threadFactory) -> new MultiThreadIoEventLoopGroup((int)nThreads, (ThreadFactory)threadFactory, NioIoHandler.newFactory()), null);
    public static final TransportTypeProvider EPOLL = TransportTypeProvider.of("EPOLL", ChannelUtil.channelPackageName(), ".epoll.Epoll", ".epoll.EpollServerSocketChannel", ".epoll.EpollSocketChannel", ".epoll.EpollServerDomainSocketChannel", ".epoll.EpollDomainSocketChannel", ".epoll.EpollDatagramChannel", ".epoll.EpollIoHandle", ".epoll.EpollIoHandler");
    public static final TransportTypeProvider KQUEUE = TransportTypeProvider.of("KQUEUE", ChannelUtil.channelPackageName(), ".kqueue.KQueue", ".kqueue.KQueueServerSocketChannel", ".kqueue.KQueueSocketChannel", ".kqueue.KQueueServerDomainSocketChannel", ".kqueue.KQueueDomainSocketChannel", ".kqueue.KQueueDatagramChannel", ".kqueue.KQueueIoHandle", ".kqueue.KQueueIoHandler");
    public static final TransportTypeProvider IO_URING = TransportTypeProvider.of("IO_URING", ChannelUtil.channelPackageName(), ".uring.IoUring", ".uring.IoUringServerSocketChannel", ".uring.IoUringSocketChannel", ".uring.IoUringServerDomainSocketChannel", ".uring.IoUringDomainSocketChannel", ".uring.IoUringDatagramChannel", ".uring.IoUringIoHandle", ".uring.IoUringIoHandler");
    private final String name;
    @Nullable
    private final Class<? extends ServerSocketChannel> serverChannelType;
    @Nullable
    private final Class<? extends SocketChannel> socketChannelType;
    @Nullable
    private final Class<? extends ServerDomainSocketChannel> domainServerChannelType;
    @Nullable
    private final Class<? extends DomainSocketChannel> domainSocketChannelType;
    @Nullable
    private final Class<? extends DatagramChannel> datagramChannelType;
    @Nullable
    private final Class<? extends IoHandle> ioHandleType;
    @Nullable
    private final BiFunction<Integer, ThreadFactory, ? extends IoEventLoopGroup> eventLoopGroupFactory;
    @Nullable
    private final Throwable unavailabilityCause;

    private static TransportTypeProvider of(String name, @Nullable String channelPackageName, String entryPointTypeName, String serverSocketChannelTypeName, String socketChannelTypeName, @Nullable String domainServerSocketChannelTypeName, @Nullable String domainSocketChannelTypeName, String datagramChannelTypeName, String ioHandleTypeName, String ioHandlerTypeName) {
        if (channelPackageName == null) {
            return new TransportTypeProvider(name, null, null, null, null, null, null, null, new IllegalStateException("Failed to determine the shaded package name"));
        }
        if ("IO_URING".equals(name)) {
            if (!"io_uring".equals(Ascii.toLowerCase(System.getProperty("io.opentelemetry.testing.internal.armeria.transportType", "")))) {
                return new TransportTypeProvider(name, null, null, null, null, null, null, null, new IllegalStateException("io_uring not enabled explicitly"));
            }
            if (SystemInfo.javaVersion() < 9) {
                return new TransportTypeProvider(name, null, null, null, null, null, null, null, new IllegalStateException("Java 9+ is required to use " + name + " transport"));
            }
        }
        try {
            Throwable unavailabilityCause = (Throwable)TransportTypeProvider.findClass(channelPackageName, entryPointTypeName).getMethod("unavailabilityCause", new Class[0]).invoke(null, new Object[0]);
            if (unavailabilityCause != null) {
                throw unavailabilityCause;
            }
            Class ssc = TransportTypeProvider.findClass(channelPackageName, serverSocketChannelTypeName);
            Class sc = TransportTypeProvider.findClass(channelPackageName, socketChannelTypeName);
            Class sdsc = domainServerSocketChannelTypeName != null ? TransportTypeProvider.findClass(channelPackageName, domainServerSocketChannelTypeName) : null;
            Class dsc = domainSocketChannelTypeName != null ? TransportTypeProvider.findClass(channelPackageName, domainSocketChannelTypeName) : null;
            Class dc = TransportTypeProvider.findClass(channelPackageName, datagramChannelTypeName);
            Class ioHandleType = TransportTypeProvider.findClass(channelPackageName, ioHandleTypeName);
            Class ioHandlerType = TransportTypeProvider.findClass(channelPackageName, ioHandlerTypeName);
            BiFunction<Integer, ThreadFactory, ? extends IoEventLoopGroup> elgf = TransportTypeProvider.findEventLoopGroupFactory(ioHandlerType);
            return new TransportTypeProvider(name, ssc, sc, sdsc, dsc, dc, ioHandleType, elgf, null);
        }
        catch (Throwable cause) {
            return new TransportTypeProvider(name, null, null, null, null, null, null, null, Exceptions.peel(cause));
        }
    }

    private static <T> Class<T> findClass(String channelPackageName, String className) throws Exception {
        return Class.forName(channelPackageName + className, false, TransportTypeProvider.class.getClassLoader());
    }

    private static BiFunction<Integer, ThreadFactory, ? extends IoEventLoopGroup> findEventLoopGroupFactory(Class<? extends IoHandler> ioHandlerType) throws Exception {
        Objects.requireNonNull(ioHandlerType, "ioHandlerType");
        MethodHandle factoryMethod = MethodHandles.lookup().findStatic(ioHandlerType, "newFactory", MethodType.methodType(IoHandlerFactory.class));
        return (nThreads, threadFactory) -> {
            try {
                IoHandlerFactory ioHandlerFactory = factoryMethod.invoke();
                return new MultiThreadIoEventLoopGroup((int)nThreads, (ThreadFactory)threadFactory, ioHandlerFactory);
            }
            catch (Throwable t) {
                return (IoEventLoopGroup)Exceptions.throwUnsafely(Exceptions.peel(t));
            }
        };
    }

    private TransportTypeProvider(String name, @Nullable Class<? extends ServerSocketChannel> serverChannelType, @Nullable Class<? extends SocketChannel> socketChannelType, @Nullable Class<? extends ServerDomainSocketChannel> domainServerChannelType, @Nullable Class<? extends DomainSocketChannel> domainSocketChannelType, @Nullable Class<? extends DatagramChannel> datagramChannelType, @Nullable Class<? extends IoHandle> ioHandleType, @Nullable BiFunction<Integer, ThreadFactory, ? extends IoEventLoopGroup> eventLoopGroupFactory, @Nullable Throwable unavailabilityCause) {
        assert (serverChannelType == null && socketChannelType == null && domainServerChannelType == null && domainSocketChannelType == null && datagramChannelType == null && ioHandleType == null && eventLoopGroupFactory == null && unavailabilityCause != null || serverChannelType != null && socketChannelType != null && datagramChannelType != null && ioHandleType != null && eventLoopGroupFactory != null && unavailabilityCause == null);
        assert (domainServerChannelType != null && domainSocketChannelType != null || domainServerChannelType == null && domainSocketChannelType == null) : domainServerChannelType + ", " + domainSocketChannelType;
        this.name = name;
        this.serverChannelType = serverChannelType;
        this.socketChannelType = socketChannelType;
        this.domainServerChannelType = domainServerChannelType;
        this.domainSocketChannelType = domainSocketChannelType;
        this.datagramChannelType = datagramChannelType;
        this.ioHandleType = ioHandleType;
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.unavailabilityCause = unavailabilityCause;
    }

    public Class<? extends ServerSocketChannel> serverChannelType() {
        return this.ensureSupported(this.serverChannelType);
    }

    public Class<? extends SocketChannel> socketChannelType() {
        return this.ensureSupported(this.socketChannelType);
    }

    public boolean supportsDomainSockets() {
        return this.domainSocketChannelType != null;
    }

    public Class<? extends ServerDomainSocketChannel> domainServerChannelType() {
        return this.ensureSupported(this.domainServerChannelType);
    }

    public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return this.ensureSupported(this.domainSocketChannelType);
    }

    public Class<? extends DatagramChannel> datagramChannelType() {
        return this.ensureSupported(this.datagramChannelType);
    }

    public Class<? extends IoHandle> ioHandleType() {
        return this.ensureSupported(this.ioHandleType);
    }

    public BiFunction<Integer, ThreadFactory, ? extends IoEventLoopGroup> eventLoopGroupFactory() {
        return this.ensureSupported(this.eventLoopGroupFactory);
    }

    @Nullable
    public Throwable unavailabilityCause() {
        return this.unavailabilityCause;
    }

    private <T> T ensureSupported(@Nullable T value) {
        if (value == null) {
            throw new IllegalStateException("transport '" + this.name + "' not available: " + this.unavailabilityCause, this.unavailabilityCause);
        }
        return value;
    }
}

