/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.encoding;

import io.opentelemetry.testing.internal.armeria.client.encoding.StreamDecoder;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.encoding.AbstractHttpDecodedResponse;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class StaticHttpDecodedResponse
extends AbstractHttpDecodedResponse {
    private final StreamDecoder decoder;
    @Nullable
    private final MediaType contentType;

    public StaticHttpDecodedResponse(HttpResponse delegate, StreamDecoder decoder, @Nullable MediaType contentType) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.decoder = Objects.requireNonNull(decoder, "decoder");
        this.contentType = contentType;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        ResponseHeaders responseHeaders;
        if (obj instanceof HttpData) {
            return this.decoder.decode((HttpData)obj);
        }
        if (obj instanceof ResponseHeaders && !(responseHeaders = (ResponseHeaders)obj).status().isInformational()) {
            ResponseHeadersBuilder builder = responseHeaders.toBuilder();
            builder.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (this.contentType == null) {
                builder.remove(HttpHeaderNames.CONTENT_TYPE);
            } else {
                builder.contentType(this.contentType);
            }
            return builder.build();
        }
        return obj;
    }

    @Override
    @Nonnull
    StreamDecoder decoder() {
        return this.decoder;
    }
}

