/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.DependencyInjector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectiveDependencyInjector
implements DependencyInjector {
    private static final Logger logger = LoggerFactory.getLogger(ReflectiveDependencyInjector.class);
    private final ReentrantLock lock = new ReentrantShortLock();
    private final Map<Class<?>, Object> instances = new HashMap();
    private boolean isShutdown;

    @Nullable
    public static <T> T create(Class<? extends T> type, @Nullable Map<Class<?>, Object> instanceStorage) {
        Object instance;
        Constructor constructor = Iterables.getFirst(ReflectionUtils.getConstructors(type, ReflectionUtils.withParametersCount(0)), null);
        if (constructor == null) {
            return null;
        }
        constructor.setAccessible(true);
        try {
            instance = constructor.newInstance(new Object[0]);
            if (instanceStorage != null) {
                instanceStorage.put(type, instance);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("cannot create an instance of " + type.getName(), t);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getInstance(Class<T> type) {
        this.lock.lock();
        try {
            if (this.isShutdown) {
                throw new IllegalStateException("Already shut down");
            }
            Object instance = this.instances.get(type);
            if (instance != null) {
                Object object = instance;
                return (T)object;
            }
            T t = ReflectiveDependencyInjector.create(type, this.instances);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
            for (Object instance : this.instances.values()) {
                if (!(instance instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)instance).close();
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while closing {}", instance);
                }
            }
            this.instances.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("instances", this.instances).toString();
    }
}

