/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.IntMath;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelConfig;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Exception;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InboundTrafficController
extends AtomicInteger {
    private static final Logger logger = LoggerFactory.getLogger(InboundTrafficController.class);
    private static final long serialVersionUID = 420503276551000218L;
    private static final InboundTrafficController DISABLED = new InboundTrafficController(null, null, 0, 0);
    private static int numDeferredReads;
    @Nullable
    private final Channel channel;
    @Nullable
    private final ChannelConfig cfg;
    @Nullable
    private final Http2ConnectionDecoder decoder;
    private final int highWatermark;
    private final int lowWatermark;
    private volatile boolean suspended;

    public static int numDeferredReads() {
        return numDeferredReads;
    }

    public static InboundTrafficController ofHttp1(Channel channel) {
        return new InboundTrafficController(channel, null, 131072, 65536);
    }

    public static InboundTrafficController ofHttp2(Channel channel, Http2ConnectionDecoder decoder, int connectionWindowSize) {
        int highWatermark = connectionWindowSize = IntMath.saturatedAdd(connectionWindowSize, 1024);
        int lowWatermark = highWatermark >>> 1;
        return new InboundTrafficController(channel, decoder, highWatermark, lowWatermark);
    }

    public static InboundTrafficController disabled() {
        return DISABLED;
    }

    private InboundTrafficController(@Nullable Channel channel, @Nullable Http2ConnectionDecoder decoder, int highWatermark, int lowWatermark) {
        this.channel = channel;
        this.cfg = channel != null ? channel.config() : null;
        this.decoder = decoder;
        this.highWatermark = highWatermark;
        this.lowWatermark = lowWatermark;
    }

    public void inc(int numProducedBytes) {
        int oldValue = this.getAndAdd(numProducedBytes);
        if (oldValue <= this.highWatermark && oldValue + numProducedBytes > this.highWatermark && this.cfg != null) {
            this.cfg.setAutoRead(false);
            ++numDeferredReads;
            this.suspended = true;
        }
    }

    public void dec(int id, int numConsumedBytes) {
        int oldValue;
        if (this.decoder != null) {
            assert (this.channel != null);
            if (this.channel.eventLoop().inEventLoop()) {
                this.consumeHttp2Bytes(id, numConsumedBytes);
            } else {
                this.channel.eventLoop().execute(() -> this.consumeHttp2Bytes(id, numConsumedBytes));
            }
        }
        if ((oldValue = this.getAndAdd(-numConsumedBytes)) > this.lowWatermark && oldValue - numConsumedBytes <= this.lowWatermark && this.cfg != null) {
            this.cfg.setAutoRead(true);
            this.suspended = false;
        }
    }

    private void consumeHttp2Bytes(int id, int numConsumedBytes) {
        int streamId = InboundTrafficController.streamId(id);
        assert (this.decoder != null && this.channel != null);
        Http2Stream stream = this.decoder.connection().stream(streamId);
        if (stream != null) {
            try {
                if (this.decoder.flowController().consumeBytes(stream, numConsumedBytes)) {
                    this.channel.flush();
                }
            }
            catch (Http2Exception e) {
                logger.warn("{} Failed to consume bytes from stream {}", new Object[]{this.channel, streamId, e});
            }
        } else if (!this.decoder.connection().streamMayHaveExisted(streamId)) {
            logger.warn("{} Stream {} not found when consuming bytes", (Object)this.channel, (Object)streamId);
        }
    }

    @Nullable
    public Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private static int streamId(int id) {
        return (id << 1) + 1;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("suspended", this.suspended).add("unconsumed", this.get()).add("watermarks", this.highWatermark + "/" + this.lowWatermark).toString();
    }
}

