/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public final class UndefinedEndpointGroup
implements EndpointGroup {
    private static final UndefinedEndpointGroup INSTANCE = new UndefinedEndpointGroup(new IllegalArgumentException("An endpointGroup has not been specified. Specify an endpointGroup by 1) building a client with a URI or EndpointGroup e.g. 'WebClient.of(uri)', 2) sending a request with the authority 'client.execute(requestWithAuthority)', or 3) setting the endpointGroup directly inside a Preprocessor via 'ctx.endpointGroup()'."));
    private final RuntimeException exception;
    private final CompletableFuture<Endpoint> failedFuture;

    public static UndefinedEndpointGroup of() {
        return INSTANCE;
    }

    private UndefinedEndpointGroup(Throwable throwable) {
        this.exception = UnprocessedRequestException.of(throwable);
        this.failedFuture = UnmodifiableFuture.exceptionallyCompletedFuture(this.exception);
    }

    @Override
    public List<Endpoint> endpoints() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".endpoints() is not supported");
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".selectionStrategy() is not supported");
    }

    @Override
    @Nullable
    public Endpoint selectNow(ClientRequestContext ctx) {
        throw this.exception;
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.failedFuture;
    }

    @Override
    public long selectionTimeoutMillis() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".selectionTimeoutMillis() is not supported");
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".whenReady() is not supported");
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("exception", this.exception).toString();
    }
}

