/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.dns;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsQuestion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecordType;
import java.net.IDN;
import java.util.Objects;

public final class DnsQuestionWithoutTrailingDot
implements DnsQuestion {
    private final String originalName;
    private final String name;
    private final DnsRecordType type;
    private final int hashCode;

    public static DnsQuestionWithoutTrailingDot of(String name, DnsRecordType type) {
        return new DnsQuestionWithoutTrailingDot(name, name, type);
    }

    public static DnsQuestionWithoutTrailingDot of(String originalName, String name, DnsRecordType type) {
        return new DnsQuestionWithoutTrailingDot(originalName, name, type);
    }

    private DnsQuestionWithoutTrailingDot(String originalName, String name, DnsRecordType type) {
        this.originalName = Objects.requireNonNull(originalName, "originalName");
        this.name = IDN.toASCII(Objects.requireNonNull(name, "name"));
        this.type = Objects.requireNonNull(type, "type");
        int hashCode = originalName.hashCode();
        hashCode = hashCode * 31 + name.hashCode();
        this.hashCode = hashCode = hashCode * 31 + type.hashCode();
    }

    public String originalName() {
        return this.originalName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DnsRecordType type() {
        return this.type;
    }

    @Override
    public int dnsClass() {
        return 1;
    }

    @Override
    public long timeToLive() {
        return 0L;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnsQuestionWithoutTrailingDot)) {
            return false;
        }
        DnsQuestionWithoutTrailingDot that = (DnsQuestionWithoutTrailingDot)o;
        return this.type.equals(that.type) && this.originalName.equals(that.originalName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DnsQuestion(").append(this.name()).append(" IN ").append(this.type().name()).append(')');
        return buf.toString();
    }
}

