/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.InternalGrpcWebTrailers;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class RuleFilter
implements BiFunction<ClientRequestContext, Throwable, Boolean> {
    private final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter;
    @Nullable
    private final BiPredicate<ClientRequestContext, Throwable> exceptionFilter;
    @Nullable
    private final BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter;
    @Nullable
    private final BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter;
    @Nullable
    private final BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter;
    @Nullable
    private final BiPredicate<ClientRequestContext, Duration> totalDurationFilter;
    private final boolean hasResponseFilter;

    public static RuleFilter of(BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter, @Nullable BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter, @Nullable BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter, @Nullable BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter, @Nullable BiPredicate<ClientRequestContext, Throwable> exceptionFilter, @Nullable BiPredicate<ClientRequestContext, Duration> totalDurationFilter, boolean hasResponseFilter) {
        return new RuleFilter(requestHeadersFilter, exceptionFilter, responseHeadersFilter, responseTrailersFilter, grpcTrailersFilter, totalDurationFilter, hasResponseFilter);
    }

    private RuleFilter(BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter, @Nullable BiPredicate<ClientRequestContext, Throwable> exceptionFilter, @Nullable BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter, @Nullable BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter, @Nullable BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter, @Nullable BiPredicate<ClientRequestContext, Duration> totalDurationFilter, boolean hasResponseFilter) {
        this.requestHeadersFilter = requestHeadersFilter;
        this.exceptionFilter = exceptionFilter;
        this.responseHeadersFilter = responseHeadersFilter;
        this.responseTrailersFilter = responseTrailersFilter;
        this.grpcTrailersFilter = grpcTrailersFilter;
        this.totalDurationFilter = totalDurationFilter;
        this.hasResponseFilter = hasResponseFilter;
    }

    @Override
    public Boolean apply(ClientRequestContext ctx, Throwable cause) {
        RequestLog log = ctx.log().partial();
        HttpRequest request = ctx.request();
        if (request != null && !this.requestHeadersFilter.test(ctx, request.headers())) {
            return false;
        }
        if (this.exceptionFilter == null && this.responseHeadersFilter == null && this.responseTrailersFilter == null && this.grpcTrailersFilter == null && this.totalDurationFilter == null && !this.hasResponseFilter) {
            return true;
        }
        return this.applySlow(ctx, cause, log);
    }

    private boolean applySlow(ClientRequestContext ctx, @Nullable Throwable cause, RequestLog log) {
        long totalDurationNanos;
        HttpHeaders responseTrailers;
        ResponseHeaders responseHeaders;
        if (cause != null && this.exceptionFilter != null && this.exceptionFilter.test(ctx, Exceptions.peel(cause))) {
            return true;
        }
        if (this.responseHeadersFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_HEADERS) && this.responseHeadersFilter.test(ctx, responseHeaders = log.responseHeaders())) {
            return true;
        }
        if (this.responseTrailersFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_TRAILERS) && this.responseTrailersFilter.test(ctx, responseTrailers = log.responseTrailers())) {
            return true;
        }
        if (this.grpcTrailersFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_TRAILERS)) {
            HttpHeaders maybeGrpcTrailers = log.responseTrailers();
            if (!maybeGrpcTrailers.contains("grpc-status") && !(maybeGrpcTrailers = log.responseHeaders()).contains("grpc-status")) {
                maybeGrpcTrailers = InternalGrpcWebTrailers.get(ctx);
            }
            if (maybeGrpcTrailers != null && this.grpcTrailersFilter.test(ctx, maybeGrpcTrailers)) {
                return true;
            }
        }
        return this.totalDurationFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_END_TIME) && this.totalDurationFilter.test(ctx, Duration.ofNanos(totalDurationNanos = log.totalDurationNanos()));
    }
}

