/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.common.util.IdentityHashStrategy;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.errorprone.annotations.concurrent.GuardedBy;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@UnstableApi
public abstract class AbstractAsyncSelector<T> {
    private final ReentrantShortLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Set<ListeningFuture> pendingFutures = new ObjectLinkedOpenCustomHashSet(IdentityHashStrategy.of());

    protected AbstractAsyncSelector() {
    }

    protected Set<? extends CompletableFuture<T>> pendingFutures() {
        return this.pendingFutures;
    }

    @Nullable
    protected abstract T selectNow(ClientRequestContext var1);

    public CompletableFuture<T> select(ClientRequestContext ctx, ScheduledExecutorService executor, long selectionTimeoutMillis) {
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        T selected = this.selectNow(ctx);
        if (selected != null) {
            return UnmodifiableFuture.completedFuture(selected);
        }
        ListeningFuture listeningFuture = new ListeningFuture(ctx, executor);
        this.addPendingFuture(listeningFuture);
        if (listeningFuture.isDone()) {
            return listeningFuture;
        }
        selected = this.selectNow(ctx);
        if (selected != null) {
            listeningFuture.complete(selected);
            return listeningFuture;
        }
        if (selectionTimeoutMillis == 0L) {
            return UnmodifiableFuture.completedFuture(null);
        }
        if (selectionTimeoutMillis < Long.MAX_VALUE) {
            ScheduledFuture<?> timeoutFuture = executor.schedule(() -> {
                this.onTimeout(ctx, selectionTimeoutMillis);
                listeningFuture.complete(null);
            }, selectionTimeoutMillis, TimeUnit.MILLISECONDS);
            listeningFuture.timeoutFuture = timeoutFuture;
            if (listeningFuture.isDone()) {
                timeoutFuture.cancel(false);
            }
        }
        return listeningFuture;
    }

    @UnstableApi
    protected void onTimeout(ClientRequestContext ctx, long selectionTimeoutMillis) {
    }

    public void refresh() {
        this.lock.lock();
        try {
            this.pendingFutures.removeIf(rec$ -> ((ListeningFuture)rec$).tryComplete());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addPendingFuture(ListeningFuture future) {
        this.lock.lock();
        try {
            this.pendingFutures.add(future);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removePendingFuture(ListeningFuture future) {
        this.lock.lock();
        try {
            this.pendingFutures.remove(future);
        }
        finally {
            this.lock.unlock();
        }
    }

    final class ListeningFuture
    extends CompletableFuture<T> {
        private final ClientRequestContext ctx;
        private final Executor executor;
        @Nullable
        private volatile T selected;
        @Nullable
        private volatile ScheduledFuture<?> timeoutFuture;

        ListeningFuture(ClientRequestContext ctx, Executor executor) {
            this.ctx = ctx;
            this.executor = executor;
        }

        private boolean tryComplete() {
            if (this.selected != null || this.isDone()) {
                return true;
            }
            try {
                Object selected = AbstractAsyncSelector.this.selectNow(this.ctx);
                if (selected == null) {
                    return false;
                }
                this.cleanup(false);
                this.selected = selected;
                this.executor.execute(() -> super.complete(selected));
                return true;
            }
            catch (Throwable t) {
                this.cleanup(false);
                super.completeExceptionally(t);
                return true;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cleanup(true);
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean complete(@Nullable T value) {
            this.cleanup(true);
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cleanup(true);
            return super.completeExceptionally(ex);
        }

        private void cleanup(boolean removePendingFuture) {
            ScheduledFuture<?> timeoutFuture;
            if (removePendingFuture) {
                AbstractAsyncSelector.this.removePendingFuture(this);
            }
            if ((timeoutFuture = this.timeoutFuture) != null) {
                this.timeoutFuture = null;
                timeoutFuture.cancel(false);
            }
        }

        @Nullable
        ScheduledFuture<?> timeoutFuture() {
            return this.timeoutFuture;
        }
    }
}

