/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.websocket;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamWriter;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocket;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketCloseStatus;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrame;

@UnstableApi
public interface WebSocketWriter
extends StreamWriter<WebSocketFrame>,
WebSocket {
    @Override
    default public void write(String text) {
        this.write(text, true);
    }

    default public void write(String text, boolean finalFragment) {
        this.write(WebSocketFrame.ofText(text, finalFragment));
    }

    @Override
    default public void write(byte[] data) {
        this.write(data, true);
    }

    default public void write(byte[] data, boolean finalFragment) {
        this.write(WebSocketFrame.ofBinary(data, finalFragment));
    }

    @Override
    default public boolean tryWrite(String text) {
        return this.tryWrite(text, true);
    }

    default public boolean tryWrite(String text, boolean finalFragment) {
        return this.tryWrite(WebSocketFrame.ofText(text, finalFragment));
    }

    @Override
    default public boolean tryWrite(byte[] data) {
        return this.tryWrite(data, true);
    }

    default public boolean tryWrite(byte[] data, boolean finalFragment) {
        return this.tryWrite(WebSocketFrame.ofBinary(data, finalFragment));
    }

    default public void writePing() {
        this.write(WebSocketFrame.ofPing());
    }

    default public void writePing(byte[] data) {
        this.write(WebSocketFrame.ofPing(data));
    }

    default public void writePong() {
        this.write(WebSocketFrame.ofPong());
    }

    default public void writePong(byte[] data) {
        this.write(WebSocketFrame.ofPong(data));
    }

    @Override
    public void close();

    public void close(WebSocketCloseStatus var1);

    public void close(WebSocketCloseStatus var1, String var2);

    @Override
    public void close(Throwable var1);
}

