/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TransportTypeProvider;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.IoEventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.ServerChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.DatagramChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.SocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public enum TransportType {
    NIO(TransportTypeProvider.NIO),
    EPOLL(TransportTypeProvider.EPOLL),
    KQUEUE(TransportTypeProvider.KQUEUE),
    IO_URING(TransportTypeProvider.IO_URING);

    private final TransportTypeProvider provider;

    private TransportType(TransportTypeProvider provider) {
        this.provider = provider;
    }

    public static Class<? extends ServerChannel> serverChannelType(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return TransportType.find(eventLoopGroup).serverChannelType();
    }

    public Class<? extends ServerChannel> serverChannelType() {
        return this.provider.serverChannelType();
    }

    public static Class<? extends SocketChannel> socketChannelType(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return TransportType.find(eventLoopGroup).socketChannelType();
    }

    public Class<? extends SocketChannel> socketChannelType() {
        return this.provider.socketChannelType();
    }

    public static boolean supportsDomainSockets(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        if (!(eventLoopGroup instanceof IoEventLoopGroup)) {
            return false;
        }
        TransportType found = TransportType.findOrNull((IoEventLoopGroup)eventLoopGroup);
        return found != null ? found.supportsDomainSockets() : false;
    }

    public boolean supportsDomainSockets() {
        return this.provider.supportsDomainSockets();
    }

    public static Class<? extends ServerDomainSocketChannel> domainServerChannelType(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return TransportType.find(eventLoopGroup).domainServerChannelType();
    }

    public Class<? extends ServerDomainSocketChannel> domainServerChannelType() {
        return this.provider.domainServerChannelType();
    }

    public static Class<? extends DomainSocketChannel> domainSocketChannelType(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return TransportType.find(eventLoopGroup).domainSocketChannelType();
    }

    public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return this.provider.domainSocketChannelType();
    }

    public static Class<? extends DatagramChannel> datagramChannelType(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return TransportType.find(eventLoopGroup).datagramChannelType();
    }

    public Class<? extends DatagramChannel> datagramChannelType() {
        return this.provider.datagramChannelType();
    }

    public static boolean isSupported(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        if (eventLoopGroup instanceof EventLoop && (eventLoopGroup = ((EventLoop)eventLoopGroup).parent()) == null) {
            return false;
        }
        if (!(eventLoopGroup instanceof IoEventLoopGroup)) {
            return false;
        }
        TransportType found = TransportType.findOrNull((IoEventLoopGroup)eventLoopGroup);
        return found != null && found.isAvailable();
    }

    private static TransportType find(EventLoopGroup eventLoopGroup) {
        if (!(eventLoopGroup instanceof IoEventLoopGroup)) {
            throw TransportType.unsupportedEventLoopType(eventLoopGroup);
        }
        TransportType found = TransportType.findOrNull((IoEventLoopGroup)eventLoopGroup);
        if (found == null) {
            throw TransportType.unsupportedEventLoopType(eventLoopGroup);
        }
        return found;
    }

    @Nullable
    private static TransportType findOrNull(IoEventLoopGroup eventLoopGroup) {
        for (TransportType type : TransportType.values()) {
            if (!type.isAvailable() || !eventLoopGroup.isCompatible(type.provider.ioHandleType())) continue;
            return type;
        }
        return null;
    }

    public String lowerCasedName() {
        return Ascii.toLowerCase(this.name());
    }

    public boolean isAvailable() {
        return this.unavailabilityCause() == null;
    }

    @Nullable
    public Throwable unavailabilityCause() {
        return this.provider.unavailabilityCause();
    }

    public EventLoopGroup newEventLoopGroup(int nThreads, Function<TransportType, ThreadFactory> threadFactoryFactory) {
        ThreadFactory threadFactory = threadFactoryFactory.apply(this);
        return this.provider.eventLoopGroupFactory().apply(nThreads, threadFactory);
    }

    private static IllegalStateException unsupportedEventLoopType(EventLoopGroup eventLoopGroup) {
        return new IllegalStateException("unsupported event loop type: " + eventLoopGroup.getClass().getName());
    }
}

