/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.common.util.ListenableAsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;

public final class AsyncCloseableSupport
implements ListenableAsyncCloseable {
    private static final AtomicIntegerFieldUpdater<AsyncCloseableSupport> closingUpdater = AtomicIntegerFieldUpdater.newUpdater(AsyncCloseableSupport.class, "closing");
    private static final AsyncCloseableSupport CLOSED = AsyncCloseableSupport.of();
    private final Consumer<CompletableFuture<?>> closeAction;
    private final CompletableFuture<?> closeFuture = new CompletableFuture();
    private final UnmodifiableFuture<?> unmodifiableCloseFuture = UnmodifiableFuture.wrap(this.closeFuture);
    private volatile int closing;

    public static AsyncCloseableSupport of() {
        return AsyncCloseableSupport.of(f -> f.complete(null));
    }

    public static AsyncCloseableSupport of(Consumer<CompletableFuture<?>> closeAction) {
        return new AsyncCloseableSupport(Objects.requireNonNull(closeAction, "closeAction"));
    }

    public static AsyncCloseableSupport closed() {
        return CLOSED;
    }

    private AsyncCloseableSupport(Consumer<CompletableFuture<?>> closeAction) {
        this.closeAction = closeAction;
    }

    @Override
    public boolean isClosing() {
        return this.closing != 0;
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.isDone();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        if (this.setClosing()) {
            this.invokeCloseAction();
        }
        return this.whenClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean setClosing = this.setClosing();
        if (setClosing) {
            this.invokeCloseAction();
        }
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.closeFuture.get();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (CancellationException e) {
                    if (setClosing) {
                        throw e;
                    }
                }
                catch (ExecutionException e) {
                    if (setClosing) {
                        throw new CompletionException(e.getCause());
                    }
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean setClosing() {
        return closingUpdater.compareAndSet(this, 0, -1);
    }

    private void invokeCloseAction() {
        try {
            this.closeAction.accept(this.closeFuture);
        }
        catch (Throwable cause) {
            this.closeFuture.completeExceptionally(cause);
        }
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.unmodifiableCloseFuture;
    }

    static {
        CLOSED.closeAsync();
    }
}

