/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.stream;

import io.opentelemetry.testing.internal.armeria.common.stream.AggregationSupport;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessageDuplicator;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;

public class StreamMessageWrapper<T>
extends AggregationSupport
implements StreamMessage<T> {
    private final StreamMessage<? extends T> delegate;

    protected StreamMessageWrapper(StreamMessage<? extends T> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
    }

    protected final StreamMessage<? extends T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean isOpen() {
        return this.delegate().isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public long demand() {
        return this.delegate.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate().whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        this.delegate().subscribe(subscriber, executor, options);
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        return this.delegate().defaultSubscriberExecutor();
    }

    @Override
    public void abort() {
        this.delegate().abort();
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.delegate().abort(cause);
    }

    @Override
    public CompletableFuture<List<T>> collect(EventExecutor executor, SubscriptionOption ... options) {
        StreamMessage<T> delegate = this.delegate();
        return delegate.collect(executor, options);
    }

    @Override
    public StreamMessageDuplicator<T> toDuplicator() {
        return this.delegate().toDuplicator();
    }

    @Override
    public StreamMessageDuplicator<T> toDuplicator(EventExecutor executor) {
        return this.delegate().toDuplicator(executor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.delegate()).toString();
    }
}

