/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.ByteStreamMessage;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

abstract class AbstractByteStreamMessageBuilder<SELF extends AbstractByteStreamMessageBuilder<SELF>> {
    private int bufferSize = 8192;
    @Nullable
    private ExecutorService executor;

    AbstractByteStreamMessageBuilder() {
    }

    final SELF self() {
        return (SELF)this;
    }

    @Nullable
    final ExecutorService executor() {
        return this.executor;
    }

    public SELF executor(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this.self();
    }

    final int bufferSize() {
        return this.bufferSize;
    }

    public SELF bufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize > 0, "bufferSize: %s (expected: > 0)", bufferSize);
        this.bufferSize = bufferSize;
        return this.self();
    }

    public abstract ByteStreamMessage build();
}

