/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.metric;

import io.opentelemetry.testing.internal.armeria.common.metric.AbstractCloseableMeterBinder;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.internal.common.util.CertificateUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Gauge;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public final class CertificateMetrics
extends AbstractCloseableMeterBinder {
    private final List<X509Certificate> certificates;
    private final MeterIdPrefix meterIdPrefix;

    CertificateMetrics(List<X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        this.certificates = certificates;
        this.meterIdPrefix = meterIdPrefix;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ArrayList<Gauge> meters = new ArrayList<Gauge>(this.certificates.size() * 2);
        for (X509Certificate certificate : this.certificates) {
            String hostname = MoreObjects.firstNonNull(CertificateUtil.getHostname(certificate), "");
            Gauge validityMeter = Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity"), certificate, x509Cert -> {
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    return 0.0;
                }
                return 1.0;
            }).description("1 if TLS certificate is in validity period, 0 if certificate is not in validity period").tags("hostname", hostname).tags(this.meterIdPrefix.tags()).register(registry);
            meters.add(validityMeter);
            Gauge validityDaysMeter = Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity.days"), certificate, x509Cert -> {
                Instant notAfter = x509Cert.getNotAfter().toInstant();
                Duration diff = Duration.between(Instant.now(), notAfter);
                return diff.toDays();
            }).description("Duration in days before TLS certificate expires, which becomes -1 if certificate is expired").tags("hostname", hostname).tags(this.meterIdPrefix.tags()).register(registry);
            meters.add(validityDaysMeter);
        }
        this.addClosingTask(() -> {
            for (Gauge meter : meters) {
                registry.remove(meter);
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("certificates", this.certificates).add("meterIdPrefix", this.meterIdPrefix).toString();
    }
}

