/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.ClientConnectionTimings;
import io.opentelemetry.testing.internal.armeria.common.logging.HeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.LogFormatter;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogAccess;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestOnlyLog;
import io.opentelemetry.testing.internal.armeria.common.logging.TextLogFormatterBuilder;
import io.opentelemetry.testing.internal.armeria.common.util.TextFormatter;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
final class TextLogFormatter
implements LogFormatter {
    static final LogFormatter DEFAULT_INSTANCE = new TextLogFormatterBuilder().build();
    private final HeadersSanitizer<String> requestHeadersSanitizer;
    private final HeadersSanitizer<String> responseHeadersSanitizer;
    private final HeadersSanitizer<String> requestTrailersSanitizer;
    private final HeadersSanitizer<String> responseTrailersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable String> requestContentSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable String> responseContentSanitizer;
    private final boolean includeContext;

    TextLogFormatter(HeadersSanitizer<String> requestHeadersSanitizer, HeadersSanitizer<String> responseHeadersSanitizer, HeadersSanitizer<String> requestTrailersSanitizer, HeadersSanitizer<String> responseTrailersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable String> requestContentSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable String> responseContentSanitizer, boolean includeContext) {
        this.requestHeadersSanitizer = requestHeadersSanitizer;
        this.responseHeadersSanitizer = responseHeadersSanitizer;
        this.requestTrailersSanitizer = requestTrailersSanitizer;
        this.responseTrailersSanitizer = responseTrailersSanitizer;
        this.requestContentSanitizer = requestContentSanitizer;
        this.responseContentSanitizer = responseContentSanitizer;
        this.includeContext = includeContext;
    }

    @Override
    public String formatRequest(RequestOnlyLog log) {
        Object content;
        String contentPreview;
        Throwable cause;
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.REQUEST_START_TIME.isAvailable(flags)) {
            if (this.includeContext) {
                return ctx + " Request: {}";
            }
            return "Request: {}";
        }
        String requestCauseString = null;
        if (RequestLogProperty.REQUEST_CAUSE.isAvailable(flags) && (cause = log.requestCause()) != null) {
            requestCauseString = cause.toString();
        }
        String sanitizedHeaders = RequestLogProperty.REQUEST_HEADERS.isAvailable(flags) ? this.requestHeadersSanitizer.apply(ctx, log.requestHeaders()) : null;
        String sanitizedPreview = null;
        if (RequestLogProperty.REQUEST_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.requestContentPreview()) != null) {
            sanitizedPreview = this.requestContentSanitizer.apply(ctx, contentPreview);
        }
        String sanitizedContent = null;
        if (RequestLogProperty.REQUEST_CONTENT.isAvailable(flags) && (content = log.requestContent()) != null) {
            sanitizedContent = this.requestContentSanitizer.apply(ctx, content);
        }
        String sanitizedTrailers = RequestLogProperty.REQUEST_TRAILERS.isAvailable(flags) && !log.requestTrailers().isEmpty() ? this.requestTrailersSanitizer.apply(ctx, log.requestTrailers()) : null;
        String ctxString = this.includeContext ? ctx.toString() + ' ' : null;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            int currentAttempt;
            StringBuilder buf = tempThreadLocals.stringBuilder();
            if (ctxString != null) {
                buf.append(ctxString);
            }
            buf.append("Request: {startTime=");
            TextFormatter.appendEpochMicros(buf, log.requestStartTimeMicros());
            if (RequestLogProperty.SESSION.isAvailable(flags)) {
                TextLogFormatter.maybeAppendConnectionTimings(log.connectionTimings(), buf);
            }
            if (RequestLogProperty.REQUEST_LENGTH.isAvailable(flags)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, log.requestLength());
            }
            if (RequestLogProperty.REQUEST_END_TIME.isAvailable(flags)) {
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, log.requestDurationNanos());
            }
            if (requestCauseString != null) {
                buf.append(", cause=").append(requestCauseString);
            }
            buf.append(", scheme=");
            if (RequestLogProperty.SCHEME.isAvailable(flags)) {
                buf.append(log.scheme().uriText());
            } else if (RequestLogProperty.SESSION.isAvailable(flags)) {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append((Object)log.sessionProtocol());
            } else {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append("unknown");
            }
            if (RequestLogProperty.NAME.isAvailable(flags)) {
                buf.append(", name=").append(log.name());
            }
            if (sanitizedHeaders != null) {
                buf.append(", headers=").append(sanitizedHeaders);
            }
            if (sanitizedPreview != null) {
                buf.append(", preview=").append(sanitizedPreview);
            }
            if (sanitizedContent != null) {
                buf.append(", content=").append(sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                buf.append(", trailers=").append(sanitizedTrailers);
            }
            if ((currentAttempt = log.currentAttempt()) > 0) {
                buf.append(", currentAttempt=").append(currentAttempt);
            }
            buf.append('}');
            String string = buf.toString();
            return string;
        }
    }

    private static void maybeAppendConnectionTimings(@Nullable ClientConnectionTimings timings, StringBuilder buf) {
        if (timings == null) {
            return;
        }
        buf.append(", Connection: {total=");
        TextFormatter.appendEpochAndElapsed(buf, timings.connectionAcquisitionStartTimeMicros(), timings.connectionAcquisitionDurationNanos());
        if (timings.dnsResolutionDurationNanos() >= 0L) {
            buf.append(", dns=");
            TextFormatter.appendEpochAndElapsed(buf, timings.dnsResolutionStartTimeMicros(), timings.dnsResolutionDurationNanos());
        }
        if (timings.pendingAcquisitionDurationNanos() >= 0L) {
            buf.append(", pending=");
            TextFormatter.appendEpochAndElapsed(buf, timings.pendingAcquisitionStartTimeMicros(), timings.pendingAcquisitionDurationNanos());
        }
        if (timings.socketConnectDurationNanos() >= 0L) {
            buf.append(", socket=");
            TextFormatter.appendEpochAndElapsed(buf, timings.socketConnectStartTimeMicros(), timings.socketConnectDurationNanos());
        }
        if (timings.tlsHandshakeDurationNanos() >= 0L) {
            buf.append(", tls=");
            TextFormatter.appendEpochAndElapsed(buf, timings.tlsHandshakeStartTimeMicros(), timings.tlsHandshakeDurationNanos());
        }
        buf.append('}');
    }

    @Override
    public String formatResponse(RequestLog log) {
        Object content;
        String contentPreview;
        Throwable cause;
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.RESPONSE_START_TIME.isAvailable(flags)) {
            if (this.includeContext) {
                return ctx + " Response: {}";
            }
            return "Response: {}";
        }
        String responseCauseString = null;
        if (RequestLogProperty.RESPONSE_CAUSE.isAvailable(flags) && (cause = log.responseCause()) != null) {
            responseCauseString = cause.toString();
        }
        String sanitizedHeaders = RequestLogProperty.RESPONSE_HEADERS.isAvailable(flags) ? this.responseHeadersSanitizer.apply(ctx, log.responseHeaders()) : null;
        String sanitizedPreview = null;
        if (RequestLogProperty.RESPONSE_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.responseContentPreview()) != null) {
            sanitizedPreview = this.responseContentSanitizer.apply(ctx, contentPreview);
        }
        String sanitizedContent = null;
        if (RequestLogProperty.RESPONSE_CONTENT.isAvailable(flags) && (content = log.responseContent()) != null) {
            sanitizedContent = this.responseContentSanitizer.apply(ctx, content);
        }
        String sanitizedTrailers = RequestLogProperty.RESPONSE_TRAILERS.isAvailable(flags) && !log.responseTrailers().isEmpty() ? this.responseTrailersSanitizer.apply(ctx, log.responseTrailers()) : null;
        String ctxString = this.includeContext ? ctx.toString() + ' ' : null;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            if (ctxString != null) {
                buf.append(ctxString);
            }
            buf.append("Response: {startTime=");
            TextFormatter.appendEpochMicros(buf, log.responseStartTimeMicros());
            if (RequestLogProperty.RESPONSE_LENGTH.isAvailable(flags)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, log.responseLength());
            }
            if (RequestLogProperty.RESPONSE_END_TIME.isAvailable(flags)) {
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, log.responseDurationNanos());
                buf.append(", totalDuration=");
                TextFormatter.appendElapsed(buf, log.totalDurationNanos());
            }
            if (responseCauseString != null) {
                buf.append(", cause=").append(responseCauseString);
            }
            if (sanitizedHeaders != null) {
                buf.append(", headers=").append(sanitizedHeaders);
            }
            if (sanitizedPreview != null) {
                buf.append(", preview=").append(sanitizedPreview);
            }
            if (sanitizedContent != null) {
                buf.append(", content=").append(sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                buf.append(", trailers=").append(sanitizedTrailers);
            }
            buf.append('}');
            List<RequestLogAccess> children = log.children();
            int numChildren = children.size();
            if (numChildren > 1) {
                buf.append(", {totalAttempts=");
                buf.append(numChildren);
                buf.append('}');
            }
            String string = buf.toString();
            return string;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("requestHeadersSanitizer", this.requestHeadersSanitizer).add("requestContentSanitizer", this.requestContentSanitizer).add("requestTrailersSanitizer", this.requestTrailersSanitizer).add("responseHeadersSanitizer", this.responseHeadersSanitizer).add("responseContentSanitizer", this.responseContentSanitizer).add("responseTrailersSanitizer", this.responseTrailersSanitizer).toString();
    }
}

