/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.logging.HeaderMaskingFunction;
import io.opentelemetry.testing.internal.armeria.common.logging.HeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.JsonHeadersSanitizerBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.TextHeadersSanitizer;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.node.ObjectNode;
import java.util.Set;

final class JsonHeadersSanitizer
implements HeadersSanitizer<JsonNode> {
    static final HeadersSanitizer<JsonNode> INSTANCE = new JsonHeadersSanitizerBuilder().build();
    private final Set<AsciiString> sensitiveHeaders;
    private final HeaderMaskingFunction maskingFunction;
    private final ObjectMapper objectMapper;

    JsonHeadersSanitizer(Set<AsciiString> sensitiveHeaders, HeaderMaskingFunction maskingFunction, ObjectMapper objectMapper) {
        this.sensitiveHeaders = sensitiveHeaders;
        this.maskingFunction = maskingFunction;
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonNode sanitize(RequestContext requestContext, HttpHeaders headers) {
        ObjectNode result = this.objectMapper.createObjectNode();
        TextHeadersSanitizer.maskHeaders(headers, this.sensitiveHeaders, this.maskingFunction, (header, values) -> result.put(header.toString(), values.size() > 1 ? values.toString() : (String)values.get(0)));
        return result;
    }
}

