/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.FieldMasker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@UnstableApi
public final class FieldMaskerBuilder {
    private final ImmutableList.Builder<TypedMasker> maskersBuilder = ImmutableList.builder();

    FieldMaskerBuilder() {
    }

    public <T> FieldMaskerBuilder addMasker(Class<T> clazz, final Function<T, T> masker) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(masker, "masker");
        this.maskersBuilder.add((Object)new TypedMasker(clazz, new FieldMasker(){

            @Override
            @Nullable
            public Object mask(Object obj) {
                return masker.apply(obj);
            }
        }));
        return this;
    }

    public <T> FieldMaskerBuilder addMasker(Class<T> clazz, final Function<T, String> encryptorFunction, final Function<String, T> decryptorFunction) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(encryptorFunction, "encryptorFunction");
        Objects.requireNonNull(decryptorFunction, "decryptorFunction");
        this.maskersBuilder.add((Object)new TypedMasker(clazz, new FieldMasker(){

            @Override
            @Nullable
            public Object mask(Object obj) {
                return encryptorFunction.apply(obj);
            }

            @Override
            public Object unmask(Object obj, Class<?> expected) {
                return decryptorFunction.apply((String)obj);
            }

            @Override
            public Class<?> mappedClass(Class<?> clazz) {
                return String.class;
            }
        }));
        return this;
    }

    public FieldMasker build() {
        return this.build(FieldMasker.noMask());
    }

    public FieldMasker build(FieldMasker defaultMasker) {
        Objects.requireNonNull(defaultMasker, "defaultMasker");
        ImmutableCollection maskers = this.maskersBuilder.build();
        return new CompositeFieldMasker((List)((Object)maskers), defaultMasker);
    }

    private static final class TypedMasker {
        private final Class<?> clazz;
        private final FieldMasker masker;

        TypedMasker(Class<?> clazz, FieldMasker masker) {
            this.clazz = clazz;
            this.masker = masker;
        }

        Class<?> clazz() {
            return this.clazz;
        }

        public FieldMasker masker() {
            return this.masker;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("clazz", this.clazz).add("masker", this.masker).toString();
        }
    }

    private static final class CompositeFieldMasker
    implements FieldMasker {
        private final List<TypedMasker> maskers;
        private final FieldMasker defaultMasker;

        private CompositeFieldMasker(List<TypedMasker> maskers, FieldMasker defaultMasker) {
            this.maskers = maskers;
            this.defaultMasker = defaultMasker;
        }

        @Override
        @Nullable
        public Object mask(@Nullable RequestContext ctx, Object obj) {
            for (TypedMasker masker : this.maskers) {
                if (!masker.clazz().isInstance(obj)) continue;
                return masker.masker().mask(ctx, obj);
            }
            return this.defaultMasker.mask(ctx, obj);
        }

        @Override
        @Nullable
        public Object mask(Object obj) {
            for (TypedMasker masker : this.maskers) {
                if (!masker.clazz().isInstance(obj)) continue;
                return masker.masker().mask(obj);
            }
            return this.defaultMasker.mask(obj);
        }

        @Override
        public Object unmask(Object obj, Class<?> expected) {
            for (TypedMasker masker : this.maskers) {
                if (!masker.clazz().isAssignableFrom(expected)) continue;
                return masker.masker().unmask(obj, expected);
            }
            return this.defaultMasker.unmask(obj, expected);
        }

        @Override
        public Class<?> mappedClass(Class<?> clazz) {
            for (TypedMasker masker : this.maskers) {
                if (!masker.clazz().isAssignableFrom(clazz)) continue;
                return masker.masker().mappedClass(clazz);
            }
            return this.defaultMasker.mappedClass(clazz);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("maskers", this.maskers).add("defaultMasker", this.defaultMasker).toString();
        }
    }
}

