/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.HeadersSanitizer;
import java.util.Objects;
import java.util.function.BiFunction;

abstract class AbstractLogFormatterBuilder<SELF extends AbstractLogFormatterBuilder<SELF, T>, T> {
    @Nullable
    private HeadersSanitizer<T> requestHeadersSanitizer;
    @Nullable
    private HeadersSanitizer<T> responseHeadersSanitizer;
    @Nullable
    private HeadersSanitizer<T> requestTrailersSanitizer;
    @Nullable
    private HeadersSanitizer<T> responseTrailersSanitizer;
    @Nullable
    private BiFunction<? super RequestContext, Object, ? extends T> requestContentSanitizer;
    @Nullable
    private BiFunction<? super RequestContext, Object, ? extends T> responseContentSanitizer;

    AbstractLogFormatterBuilder() {
    }

    final SELF self() {
        return (SELF)this;
    }

    public SELF requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable T> requestHeadersSanitizer) {
        Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestHeadersSanitizer = requestHeadersSanitizer::apply;
        return this.self();
    }

    @Nullable
    final HeadersSanitizer<T> requestHeadersSanitizer() {
        return this.requestHeadersSanitizer;
    }

    public SELF responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable T> responseHeadersSanitizer) {
        Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseHeadersSanitizer = responseHeadersSanitizer::apply;
        return this.self();
    }

    @Nullable
    final HeadersSanitizer<T> responseHeadersSanitizer() {
        return this.responseHeadersSanitizer;
    }

    public SELF requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable T> requestTrailersSanitizer) {
        Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        this.requestTrailersSanitizer = requestTrailersSanitizer::apply;
        return this.self();
    }

    @Nullable
    final HeadersSanitizer<T> requestTrailersSanitizer() {
        return this.requestTrailersSanitizer;
    }

    public SELF responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable T> responseTrailersSanitizer) {
        Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        this.responseTrailersSanitizer = responseTrailersSanitizer::apply;
        return this.self();
    }

    @Nullable
    final HeadersSanitizer<T> responseTrailersSanitizer() {
        return this.responseTrailersSanitizer;
    }

    public SELF headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable T> headersSanitizer) {
        Objects.requireNonNull(headersSanitizer, "headersSanitizer");
        this.requestHeadersSanitizer(headersSanitizer);
        this.requestTrailersSanitizer(headersSanitizer);
        this.responseHeadersSanitizer(headersSanitizer);
        this.responseTrailersSanitizer(headersSanitizer);
        return this.self();
    }

    public SELF requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable T> requestContentSanitizer) {
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        return this.self();
    }

    @Nullable
    final @Nullable BiFunction<? super RequestContext, Object, ? extends @Nullable T> requestContentSanitizer() {
        return this.requestContentSanitizer;
    }

    public SELF responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable T> responseContentSanitizer) {
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        return this.self();
    }

    @Nullable
    final @Nullable BiFunction<? super RequestContext, Object, ? extends @Nullable T> responseContentSanitizer() {
        return this.responseContentSanitizer;
    }

    public SELF contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable T> contentSanitizer) {
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        this.requestContentSanitizer(contentSanitizer);
        this.responseContentSanitizer(contentSanitizer);
        return this.self();
    }
}

