/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.SimpleLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.Weighted;
import io.opentelemetry.testing.internal.armeria.internal.common.loadbalancer.WeightedObject;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import io.opentelemetry.testing.internal.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToIntFunction;

final class WeightedRandomLoadBalancer<T>
implements SimpleLoadBalancer<T> {
    private final ReentrantLock lock = new ReentrantShortLock();
    private final List<CandidateContext<T>> allEntries;
    @GuardedBy(value="lock")
    private final List<CandidateContext<T>> currentEntries;
    private final long total;
    private long remaining;

    WeightedRandomLoadBalancer(Iterable<? extends T> candidates, @Nullable ToIntFunction<? super T> weightFunction) {
        List candidateContexts = Streams.stream(candidates).map(e -> {
            if (weightFunction == null) {
                return new CandidateContext<Object>(e, ((Weighted)e).weight());
            }
            return new CandidateContext<Object>(e, weightFunction.applyAsInt(e));
        }).filter(e -> e.weight() > 0).collect(ImmutableList.toImmutableList());
        this.remaining = this.total = candidateContexts.stream().mapToLong(WeightedObject::weight).sum();
        this.allEntries = candidateContexts;
        this.currentEntries = new ArrayList<CandidateContext<T>>(this.allEntries);
    }

    List<CandidateContext<T>> entries() {
        return this.allEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T pick() {
        if (this.allEntries.isEmpty()) {
            return null;
        }
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        this.lock.lock();
        try {
            long target = threadLocalRandom.nextLong(this.remaining);
            Iterator<CandidateContext<T>> it = this.currentEntries.iterator();
            while (it.hasNext()) {
                CandidateContext<T> entry = it.next();
                int weight = entry.weight();
                if ((target -= (long)weight) >= 0L) continue;
                entry.increment();
                if (entry.isFull()) {
                    it.remove();
                    entry.reset();
                    this.remaining -= (long)weight;
                    if (this.remaining == 0L) {
                        this.currentEntries.addAll(this.allEntries);
                        this.remaining = this.total;
                    } else assert (this.remaining > 0L) : this.remaining;
                }
                Object t = entry.get();
                return t;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new Error("Should never reach here");
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("allEntries", this.allEntries).add("currentEntries", this.currentEntries).add("total", this.total).add("remaining", this.remaining).toString();
    }

    static final class CandidateContext<T>
    extends WeightedObject<T> {
        private int counter;

        CandidateContext(T candidate, int weight) {
            super(candidate, weight);
        }

        void increment() {
            assert (this.counter < this.weight());
            ++this.counter;
        }

        void reset() {
            this.counter = 0;
        }

        int counter() {
            return this.counter;
        }

        boolean isFull() {
            return this.counter >= this.weight();
        }
    }
}

