/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.SimpleLoadBalancer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class RoundRobinLoadBalancer<T>
implements SimpleLoadBalancer<T> {
    private final AtomicInteger sequence = new AtomicInteger();
    private final List<T> candidates;

    RoundRobinLoadBalancer(Iterable<? extends T> candidates) {
        this.candidates = ImmutableList.copyOf(candidates);
    }

    @Override
    @Nullable
    public T pick() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        int currentSequence = this.sequence.getAndIncrement();
        return this.candidates.get(Math.abs(currentSequence % this.candidates.size()));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("candidates", this.candidates).toString();
    }
}

