/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.CommonPools;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.AbstractRampingUpLoadBalancerBuilder;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.RampingUpLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.UpdatableLoadBalancer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.function.ToIntFunction;

@UnstableApi
public final class RampingUpLoadBalancerBuilder<T>
extends AbstractRampingUpLoadBalancerBuilder<T, RampingUpLoadBalancerBuilder<T>> {
    private final List<T> candidates;
    @Nullable
    private final ToIntFunction<T> weightFunction;

    RampingUpLoadBalancerBuilder(Iterable<T> candidates, @Nullable ToIntFunction<T> weightFunction) {
        this.candidates = ImmutableList.copyOf(candidates);
        this.weightFunction = weightFunction;
    }

    public UpdatableLoadBalancer<T> build() {
        this.validate();
        EventExecutor executor = this.executor();
        if (executor == null) {
            executor = CommonPools.workerGroup().next();
        }
        return new RampingUpLoadBalancer<T>(this.candidates, this.weightFunction, this.rampingUpIntervalMillis(), this.totalSteps(), this.rampingUpTaskWindowMillis(), this.weightTransition(), this.timestampFunction(), this.ticker(), executor);
    }
}

