/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.RampingUpLoadBalancerBuilder;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.RoundRobinLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.SimpleLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.StickyLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.UpdatableLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.Weighted;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightedRandomLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightedRoundRobinLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

@UnstableApi
public interface LoadBalancer<T, C>
extends SafeCloseable {
    public static <T> SimpleLoadBalancer<T> ofRoundRobin(Iterable<? extends T> candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return new RoundRobinLoadBalancer<T>(candidates);
    }

    public static <T> SimpleLoadBalancer<T> ofWeightedRoundRobin(Iterable<? extends T> candidates, ToIntFunction<? super T> weightFunction) {
        Objects.requireNonNull(candidates, "candidates");
        Objects.requireNonNull(weightFunction, "weightFunction");
        return new WeightedRoundRobinLoadBalancer<T>(candidates, weightFunction);
    }

    public static <T extends Weighted> SimpleLoadBalancer<T> ofWeightedRoundRobin(Iterable<? extends T> candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return new WeightedRoundRobinLoadBalancer<T>(candidates, null);
    }

    @SafeVarargs
    public static <T extends Weighted> SimpleLoadBalancer<T> ofWeightedRoundRobin(T ... candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return LoadBalancer.ofWeightedRoundRobin(ImmutableList.copyOf(candidates));
    }

    public static <T, C> LoadBalancer<T, C> ofSticky(Iterable<? extends T> candidates, ToLongFunction<? super C> contextHasher) {
        Objects.requireNonNull(candidates, "candidates");
        Objects.requireNonNull(contextHasher, "contextHasher");
        return new StickyLoadBalancer<T, C>(candidates, contextHasher);
    }

    public static <T, C> SimpleLoadBalancer<T> ofWeightedRandom(Iterable<? extends T> candidates, ToIntFunction<? super T> weightFunction) {
        Objects.requireNonNull(candidates, "candidates");
        Objects.requireNonNull(weightFunction, "weightFunction");
        return new WeightedRandomLoadBalancer<T>(candidates, weightFunction);
    }

    public static <T extends Weighted> SimpleLoadBalancer<T> ofWeightedRandom(Iterable<? extends T> candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return new WeightedRandomLoadBalancer<T>(candidates, null);
    }

    @SafeVarargs
    public static <T extends Weighted> SimpleLoadBalancer<T> ofWeightedRandom(T ... candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return LoadBalancer.ofWeightedRandom(ImmutableList.copyOf(candidates));
    }

    public static <T> UpdatableLoadBalancer<T> ofRampingUp(Iterable<? extends T> candidates, ToIntFunction<? super T> weightFunction) {
        Objects.requireNonNull(candidates, "candidates");
        Objects.requireNonNull(weightFunction, "weightFunction");
        return LoadBalancer.builderForRampingUp(candidates, weightFunction).build();
    }

    public static <T extends Weighted> UpdatableLoadBalancer<T> ofRampingUp(Iterable<? extends T> candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return LoadBalancer.builderForRampingUp(candidates).build();
    }

    @SafeVarargs
    public static <T extends Weighted> UpdatableLoadBalancer<T> ofRampingUp(T ... candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return LoadBalancer.ofRampingUp(ImmutableList.copyOf(candidates));
    }

    public static <T> RampingUpLoadBalancerBuilder<T> builderForRampingUp(Iterable<? extends T> candidates, ToIntFunction<? super T> weightFunction) {
        Objects.requireNonNull(candidates, "candidates");
        Objects.requireNonNull(weightFunction, "weightFunction");
        return new RampingUpLoadBalancerBuilder<T>(candidates, weightFunction);
    }

    public static <T extends Weighted> RampingUpLoadBalancerBuilder<T> builderForRampingUp(Iterable<? extends T> candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return new RampingUpLoadBalancerBuilder<T>(candidates, null);
    }

    @SafeVarargs
    public static <T extends Weighted> RampingUpLoadBalancerBuilder<T> builderForRampingUp(T ... candidates) {
        Objects.requireNonNull(candidates, "candidates");
        return LoadBalancer.builderForRampingUp(ImmutableList.copyOf(candidates));
    }

    @Nullable
    public T pick(C var1);

    @Override
    default public void close() {
    }
}

