/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightTransition;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;

final class LinearWeightTransition<T>
implements WeightTransition<T> {
    static final LinearWeightTransition<?> INSTANCE = new LinearWeightTransition();

    LinearWeightTransition() {
    }

    @Override
    public int compute(T candidate, int weight, int currentStep, int totalSteps) {
        int currentWeight = Ints.saturatedCast((long)weight * (long)currentStep / (long)totalSteps);
        if (weight > 0 && currentWeight == 0) {
            return 1;
        }
        return currentWeight;
    }

    public String toString() {
        return "WeightTransition.linear()";
    }
}

