/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightTransition;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

@UnstableApi
public abstract class AbstractRampingUpLoadBalancerBuilder<T, SELF extends AbstractRampingUpLoadBalancerBuilder<T, SELF>> {
    private static final long DEFAULT_RAMPING_UP_INTERVAL_MILLIS = 2000L;
    private static final int DEFAULT_TOTAL_STEPS = 10;
    private static final int DEFAULT_RAMPING_UP_TASK_WINDOW_MILLIS = 500;
    private static final Function<?, @Nullable Long> DEFAULT_TIMESTAMP_FUNCTION = c -> null;
    private WeightTransition<T> weightTransition = WeightTransition.linear();
    @Nullable
    private EventExecutor executor;
    private long rampingUpIntervalMillis = 2000L;
    private int totalSteps = 10;
    private long rampingUpTaskWindowMillis = 500L;
    private Ticker ticker = Ticker.systemTicker();
    private Function<T, Long> timestampFunction = DEFAULT_TIMESTAMP_FUNCTION;

    protected AbstractRampingUpLoadBalancerBuilder() {
    }

    public final SELF weightTransition(WeightTransition<T> transition) {
        this.weightTransition = Objects.requireNonNull(transition, "transition");
        return this.self();
    }

    protected final WeightTransition<T> weightTransition() {
        return this.weightTransition;
    }

    public SELF executor(EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
        return this.self();
    }

    @Nullable
    protected final EventExecutor executor() {
        return this.executor;
    }

    public SELF rampingUpInterval(Duration rampingUpInterval) {
        Objects.requireNonNull(rampingUpInterval, "rampingUpInterval");
        return this.rampingUpIntervalMillis(rampingUpInterval.toMillis());
    }

    public SELF rampingUpIntervalMillis(long rampingUpIntervalMillis) {
        Preconditions.checkArgument(rampingUpIntervalMillis > 0L, "rampingUpIntervalMillis: %s (expected: > 0)", rampingUpIntervalMillis);
        this.rampingUpIntervalMillis = rampingUpIntervalMillis;
        return this.self();
    }

    protected final long rampingUpIntervalMillis() {
        return this.rampingUpIntervalMillis;
    }

    public SELF totalSteps(int totalSteps) {
        Preconditions.checkArgument(totalSteps > 0, "totalSteps: %s (expected: > 0)", totalSteps);
        this.totalSteps = totalSteps;
        return this.self();
    }

    protected final int totalSteps() {
        return this.totalSteps;
    }

    public SELF rampingUpTaskWindow(Duration rampingUpTaskWindow) {
        Objects.requireNonNull(rampingUpTaskWindow, "rampingUpTaskWindow");
        return this.rampingUpTaskWindowMillis(rampingUpTaskWindow.toMillis());
    }

    public SELF rampingUpTaskWindowMillis(long rampingUpTaskWindowMillis) {
        Preconditions.checkArgument(rampingUpTaskWindowMillis >= 0L, "rampingUpTaskWindowMillis: %s (expected >= 0)", rampingUpTaskWindowMillis);
        this.rampingUpTaskWindowMillis = rampingUpTaskWindowMillis;
        return this.self();
    }

    protected final long rampingUpTaskWindowMillis() {
        return this.rampingUpTaskWindowMillis;
    }

    public SELF timestampFunction(Function<? super T, @Nullable Long> timestampFunction) {
        Objects.requireNonNull(timestampFunction, "timestampFunction");
        this.timestampFunction = timestampFunction;
        return this.self();
    }

    protected final Function<T, Long> timestampFunction() {
        return this.timestampFunction;
    }

    public SELF ticker(Ticker ticker) {
        Objects.requireNonNull(ticker, "ticker");
        this.ticker = ticker;
        return this.self();
    }

    protected final Ticker ticker() {
        return this.ticker;
    }

    private SELF self() {
        AbstractRampingUpLoadBalancerBuilder self = this;
        return (SELF)self;
    }

    protected final void validate() {
        Preconditions.checkState(this.rampingUpIntervalMillis > this.rampingUpTaskWindowMillis, "rampingUpIntervalMillis: %s, rampingUpTaskWindowMillis: %s (expected: rampingUpIntervalMillis > rampingUpTaskWindowMillis)", this.rampingUpIntervalMillis, this.rampingUpTaskWindowMillis);
    }
}

