/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public final class Scheme
implements Comparable<Scheme> {
    private static final Map<String, Scheme> SCHEMES;
    private final SerializationFormat serializationFormat;
    private final SessionProtocol sessionProtocol;
    private final String uriText;

    @Nullable
    public static Scheme tryParse(@Nullable String scheme) {
        if (scheme == null) {
            return null;
        }
        String lowercaseScheme = Ascii.toLowerCase(scheme);
        Scheme parsedScheme = SCHEMES.get(lowercaseScheme);
        if (parsedScheme != null) {
            return parsedScheme;
        }
        return SCHEMES.get(SerializationFormat.NONE.uriText() + '+' + lowercaseScheme);
    }

    public static Scheme parse(String scheme) {
        Scheme parsedScheme = Scheme.tryParse(Objects.requireNonNull(scheme, "scheme"));
        if (parsedScheme == null) {
            throw new IllegalArgumentException("scheme: " + scheme);
        }
        return parsedScheme;
    }

    public static Scheme of(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        Scheme scheme = SCHEMES.get(Objects.requireNonNull(serializationFormat, "serializationFormat").uriText() + '+' + Objects.requireNonNull(sessionProtocol, "sessionProtocol").uriText());
        assert (scheme != null);
        return scheme;
    }

    private Scheme(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.uriText = this.serializationFormat().uriText() + '+' + this.sessionProtocol().uriText();
    }

    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public String uriText() {
        return this.uriText;
    }

    public String shortUriText() {
        if (this.serializationFormat() == SerializationFormat.NONE) {
            return this.sessionProtocol().uriText();
        }
        return this.uriText;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(Scheme o) {
        return this.uriText().compareTo(o.uriText());
    }

    public String toString() {
        return this.uriText();
    }

    static {
        ImmutableMap.Builder<String, Scheme> schemes = ImmutableMap.builder();
        for (SerializationFormat f : SerializationFormat.values()) {
            for (SessionProtocol p : SessionProtocol.values()) {
                String ftxt = f.uriText();
                String ptxt = p.uriText();
                assert (ftxt.equals(Ascii.toLowerCase(ftxt)));
                assert (ptxt.equals(Ascii.toLowerCase(ptxt)));
                Scheme scheme = new Scheme(f, p);
                schemes.put(ftxt + '+' + ptxt, scheme);
                schemes.put(ptxt + '+' + ftxt, scheme);
                if (SerializationFormat.WS != f) continue;
                if (SessionProtocol.HTTP == p) {
                    schemes.put("ws", scheme);
                    continue;
                }
                if (SessionProtocol.HTTPS != p) continue;
                schemes.put("wss", scheme);
            }
        }
        SCHEMES = schemes.build();
    }
}

