/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.DefaultResponseEntity;
import io.opentelemetry.testing.internal.armeria.common.HttpEntity;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.util.Objects;

@UnstableApi
public interface ResponseEntity<T>
extends HttpEntity<T> {
    public static <T> ResponseEntity<T> of(ResponseHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return new DefaultResponseEntity<Object>(headers, null, HttpHeaders.of());
    }

    public static <T> ResponseEntity<T> of(ResponseHeaders headers, T content) {
        return ResponseEntity.of(headers, content, HttpHeaders.of());
    }

    public static <T> ResponseEntity<T> of(ResponseHeaders headers, T content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        return new DefaultResponseEntity<T>(headers, content, trailers);
    }

    public static <T> ResponseEntity<T> of(HttpStatus status) {
        return ResponseEntity.of(ResponseHeaders.of(status));
    }

    public static <T> ResponseEntity<T> of(HttpStatus status, T content) {
        return ResponseEntity.of(ResponseHeaders.of(status), content);
    }

    public static <T> ResponseEntity<T> of(HttpStatus status, T content, HttpHeaders trailers) {
        return ResponseEntity.of(ResponseHeaders.of(status), content, trailers);
    }

    public static <T> ResponseEntity<T> of(T content) {
        return ResponseEntity.of(HttpStatus.OK, content);
    }

    @Override
    public ResponseHeaders headers();

    default public HttpStatus status() {
        return this.headers().status();
    }
}

