/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareScheduledExecutorService;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

final class PropagatingContextAwareScheduledExecutorService
extends AbstractContextAwareScheduledExecutorService<ScheduledExecutorService> {
    static PropagatingContextAwareScheduledExecutorService of(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof PropagatingContextAwareScheduledExecutorService) {
            return (PropagatingContextAwareScheduledExecutorService)executor;
        }
        return new PropagatingContextAwareScheduledExecutorService(executor);
    }

    private PropagatingContextAwareScheduledExecutorService(ScheduledExecutorService executor) {
        super(executor);
    }

    @Override
    @Nullable
    RequestContext contextOrNull() {
        return RequestContext.mapCurrent(Function.identity(), AbstractContextAwareExecutor.LogRequestContextWarningOnce.INSTANCE);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("executor", this.withoutContext()).toString();
    }
}

