/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ByteArrayHttpData;
import io.opentelemetry.testing.internal.armeria.common.ByteBufHttpData;
import io.opentelemetry.testing.internal.armeria.common.Bytes;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.errorprone.annotations.FormatMethod;
import io.opentelemetry.testing.internal.errorprone.annotations.FormatString;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public interface HttpData
extends Bytes,
HttpObject {
    public static HttpData empty() {
        return ByteArrayHttpData.EMPTY;
    }

    public static HttpData wrap(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData(data);
    }

    public static HttpData wrap(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data");
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", data.length: " + data.length);
        }
        if (length == 0) {
            return HttpData.empty();
        }
        if (data.length == length) {
            return new ByteArrayHttpData(data);
        }
        return new ByteBufHttpData(Unpooled.wrappedBuffer(data, offset, length), false);
    }

    @UnstableApi
    public static HttpData wrap(ByteBuf buf) {
        Objects.requireNonNull(buf, "buf");
        int length = buf.readableBytes();
        if (length == 0) {
            buf.release();
            return HttpData.empty();
        }
        ByteBufHttpData data = new ByteBufHttpData(buf, true);
        buf.touch(data);
        return data;
    }

    public static HttpData copyOf(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData((byte[])data.clone());
    }

    public static HttpData copyOf(byte[] data, int offset, int length) {
        Objects.requireNonNull(data);
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", data.length: " + data.length);
        }
        if (length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData(Arrays.copyOfRange(data, offset, offset + length));
    }

    public static HttpData copyOf(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        data.touch(data);
        if (!data.isReadable()) {
            return HttpData.empty();
        }
        return HttpData.wrap(ByteBufUtil.getBytes(data));
    }

    public static HttpData of(Charset charset, CharSequence text) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(text, "text");
        if (text instanceof String) {
            return HttpData.of(charset, (String)text);
        }
        if (text.length() == 0) {
            return HttpData.empty();
        }
        CharBuffer cb = CharBuffer.wrap(text);
        ByteBuffer buf = charset.encode(cb);
        if (buf.arrayOffset() == 0 && buf.remaining() == buf.array().length) {
            return HttpData.wrap(buf.array());
        }
        return HttpData.copyOf(buf.array(), buf.arrayOffset(), buf.remaining());
    }

    public static HttpData of(Charset charset, String text) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(text, "text");
        if (text.isEmpty()) {
            return HttpData.empty();
        }
        return HttpData.wrap(text.getBytes(charset));
    }

    @FormatMethod
    public static HttpData of(Charset charset, @FormatString String format, Object ... args) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        if (format.isEmpty()) {
            return HttpData.empty();
        }
        return HttpData.wrap(String.format(Locale.ENGLISH, format, args).getBytes(charset));
    }

    public static HttpData ofUtf8(CharSequence text) {
        return HttpData.of(StandardCharsets.UTF_8, text);
    }

    public static HttpData ofUtf8(String text) {
        return HttpData.of(StandardCharsets.UTF_8, text);
    }

    @FormatMethod
    public static HttpData ofUtf8(@FormatString String format, Object ... args) {
        return HttpData.of(StandardCharsets.UTF_8, format, args);
    }

    public static HttpData ofAscii(CharSequence text) {
        return HttpData.of(StandardCharsets.US_ASCII, text);
    }

    public static HttpData ofAscii(String text) {
        return HttpData.of(StandardCharsets.US_ASCII, text);
    }

    @FormatMethod
    public static HttpData ofAscii(@FormatString String format, Object ... args) {
        return HttpData.of(StandardCharsets.US_ASCII, format, args);
    }

    default public HttpData withEndOfStream() {
        return this.withEndOfStream(true);
    }

    public HttpData withEndOfStream(boolean var1);
}

