/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponseDuplicator;
import io.opentelemetry.testing.internal.armeria.common.stream.DefaultStreamMessageDuplicator;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessageWrapper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class DefaultHttpResponseDuplicator
extends DefaultStreamMessageDuplicator<HttpObject>
implements HttpResponseDuplicator {
    DefaultHttpResponseDuplicator(HttpResponse res, EventExecutor executor, long maxResponseLength) {
        super(Objects.requireNonNull(res, "res"), obj -> {
            if (obj instanceof HttpData) {
                return ((HttpData)obj).length();
            }
            return 0;
        }, executor, maxResponseLength);
    }

    @Override
    public HttpResponse duplicate() {
        return new DuplicatedHttpResponse(super.duplicate());
    }

    private class DuplicatedHttpResponse
    extends StreamMessageWrapper<HttpObject>
    implements HttpResponse {
        DuplicatedHttpResponse(StreamMessage<? extends HttpObject> delegate) {
            super(delegate);
        }

        @Override
        public CompletableFuture<AggregatedHttpResponse> aggregate(AggregationOptions options) {
            return super.aggregate(options);
        }

        @Override
        public HttpResponseDuplicator toDuplicator() {
            return HttpResponse.super.toDuplicator();
        }

        @Override
        public HttpResponseDuplicator toDuplicator(EventExecutor executor) {
            return HttpResponse.super.toDuplicator(executor);
        }

        @Override
        public EventExecutor defaultSubscriberExecutor() {
            return DefaultHttpResponseDuplicator.this.duplicatorExecutor();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).toString();
        }
    }
}

