/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareBiConsumer;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.context.ArmeriaContextPropagation;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import java.util.function.BiConsumer;

final class DefaultContextAwareBiConsumer<T, U>
implements ContextAwareBiConsumer<T, U> {
    private final RequestContext context;
    private final BiConsumer<T, U> action;
    private final ContextSnapshot contextSnapshot;

    DefaultContextAwareBiConsumer(RequestContext context, BiConsumer<T, U> action) {
        this.context = Objects.requireNonNull(context, "context");
        this.action = Objects.requireNonNull(action, "action");
        this.contextSnapshot = ArmeriaContextPropagation.captureAll();
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public BiConsumer<T, U> withoutContext() {
        return this.action;
    }

    @Override
    public void accept(T t, U u) {
        try (SafeCloseable ignored = this.context.push();
             ContextSnapshot.Scope ignored2 = this.contextSnapshot.setThreadLocals();){
            this.action.accept(t, u);
        }
    }
}

