/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareExecutorService;
import io.opentelemetry.testing.internal.armeria.common.DefaultContextAwareScheduledExecutorService;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;

public interface ContextAwareScheduledExecutorService
extends ContextAwareExecutorService,
ScheduledExecutorService {
    public static ContextAwareScheduledExecutorService of(RequestContext context, ScheduledExecutorService executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareScheduledExecutorService) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareScheduledExecutorService)executor, ContextAwareScheduledExecutorService.class);
            return (ContextAwareScheduledExecutorService)executor;
        }
        return new DefaultContextAwareScheduledExecutorService(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public ScheduledExecutorService withoutContext();
}

