/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareScheduledExecutorService;
import io.opentelemetry.testing.internal.armeria.common.DefaultContextAwareEventLoop;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import java.util.Objects;

public interface ContextAwareEventLoop
extends ContextAwareScheduledExecutorService,
EventLoop {
    public static ContextAwareEventLoop of(RequestContext context, EventLoop eventLoop) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(eventLoop, "eventLoop");
        if (eventLoop instanceof ContextAwareEventLoop) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareEventLoop)eventLoop, ContextAwareEventLoop.class);
            return (ContextAwareEventLoop)eventLoop;
        }
        return new DefaultContextAwareEventLoop(context, eventLoop);
    }

    @Override
    public RequestContext context();

    @Override
    public EventLoop withoutContext();
}

