/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContentTooLargeException;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public final class ContentTooLargeExceptionBuilder {
    private long maxContentLength = -1L;
    private long contentLength = -1L;
    private long transferred = -1L;
    private boolean earlyRejection;
    @Nullable
    private Throwable cause;

    ContentTooLargeExceptionBuilder() {
    }

    public ContentTooLargeExceptionBuilder maxContentLength(long maxContentLength) {
        Preconditions.checkArgument(maxContentLength >= 0L, "maxContentLength: %s (expected: >= 0)", maxContentLength);
        this.maxContentLength = maxContentLength;
        return this;
    }

    public ContentTooLargeExceptionBuilder contentLength(long contentLength) {
        Preconditions.checkArgument(contentLength >= 0L, "contentLength: %s (expected: >= 0)", contentLength);
        this.contentLength = contentLength;
        return this;
    }

    public ContentTooLargeExceptionBuilder contentLength(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        this.contentLength = headers.contentLength();
        return this;
    }

    public ContentTooLargeExceptionBuilder transferred(long transferred) {
        Preconditions.checkArgument(transferred >= 0L, "transferred: %s (expected: >= 0)", transferred);
        this.transferred = transferred;
        return this;
    }

    @UnstableApi
    public ContentTooLargeExceptionBuilder cause(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.cause = cause;
        return this;
    }

    @UnstableApi
    public ContentTooLargeExceptionBuilder earlyRejection(boolean isEarlyRejection) {
        this.earlyRejection = isEarlyRejection;
        return this;
    }

    public ContentTooLargeException build() {
        if (this.maxContentLength < 0L && this.contentLength < 0L && this.transferred < 0L && !this.earlyRejection && this.cause == null) {
            return ContentTooLargeException.get();
        }
        return new ContentTooLargeException(this.maxContentLength, this.contentLength, this.transferred, this.earlyRejection, this.cause);
    }
}

