/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.CookieUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.internal.InternalThreadLocalMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

final class ClientCookieEncoder {
    private static final Cookie[] EMPTY_COOKIES = new Cookie[0];
    private static final Comparator<Cookie> COOKIE_COMPARATOR = (c1, c2) -> {
        int len1;
        String path1 = c1.path();
        String path2 = c2.path();
        int len2 = path2 == null ? Integer.MAX_VALUE : path2.length();
        int res = Integer.compare(len2, len1 = path1 == null ? Integer.MAX_VALUE : path1.length());
        if (res != 0) {
            return res;
        }
        return -1;
    };

    static String encode(boolean strict, Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        StringBuilder buf = CookieUtil.stringBuilder();
        ClientCookieEncoder.encode(strict, buf, cookie);
        return CookieUtil.stripTrailingSeparator(buf);
    }

    static String encode(boolean strict, Cookie ... cookies) {
        assert (cookies.length != 0) : cookies.length;
        StringBuilder buf = CookieUtil.stringBuilder();
        if (strict) {
            if (cookies.length == 1) {
                ClientCookieEncoder.encode(true, buf, cookies[0]);
            } else {
                Cookie[] cookiesSorted = Arrays.copyOf(cookies, cookies.length);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    ClientCookieEncoder.encode(true, buf, c);
                }
            }
        } else {
            for (Cookie c : cookies) {
                ClientCookieEncoder.encode(false, buf, c);
            }
        }
        return CookieUtil.stripTrailingSeparator(buf);
    }

    static String encode(boolean strict, Iterator<? extends Cookie> cookiesIt) {
        assert (cookiesIt.hasNext());
        StringBuilder buf = CookieUtil.stringBuilder();
        if (strict) {
            Cookie firstCookie = cookiesIt.next();
            if (!cookiesIt.hasNext()) {
                ClientCookieEncoder.encode(true, buf, firstCookie);
            } else {
                ArrayList<Cookie> cookiesList = InternalThreadLocalMap.get().arrayList();
                cookiesList.add(firstCookie);
                while (cookiesIt.hasNext()) {
                    cookiesList.add(cookiesIt.next());
                }
                Cookie[] cookiesSorted = cookiesList.toArray(EMPTY_COOKIES);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    ClientCookieEncoder.encode(true, buf, c);
                }
            }
        } else {
            do {
                ClientCookieEncoder.encode(false, buf, cookiesIt.next());
            } while (cookiesIt.hasNext());
        }
        return CookieUtil.stripTrailingSeparator(buf);
    }

    private static void encode(boolean strict, StringBuilder buf, Cookie c) {
        String name = c.name();
        String value = MoreObjects.firstNonNull(c.value(), "");
        CookieUtil.validateCookie(strict, name, value);
        if (c.isValueQuoted()) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            CookieUtil.add(buf, name, value);
        }
    }

    private ClientCookieEncoder() {
    }
}

