/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import java.nio.charset.Charset;

public interface AggregatedHttpObject {
    public HttpHeaders headers();

    public HttpData content();

    default public String content(Charset charset) {
        Charset contentTypeCharset;
        MediaType contentType = this.headers().contentType();
        if (contentType != null && (contentTypeCharset = contentType.charset()) != null) {
            return this.content().toString(contentTypeCharset);
        }
        return this.content().toString(charset);
    }

    default public String contentUtf8() {
        return this.content().toStringUtf8();
    }

    default public String contentAscii() {
        return this.content().toStringAscii();
    }

    @Nullable
    default public MediaType contentType() {
        return this.headers().contentType();
    }
}

