/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.context.ArmeriaContextPropagation;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class AbstractContextAwareExecutorService<ES extends ExecutorService>
extends AbstractContextAwareExecutor<ES>
implements ExecutorService {
    AbstractContextAwareExecutorService(ES executor) {
        super(executor);
    }

    @Override
    public final void shutdown() {
        ((ExecutorService)this.withoutContext()).shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return ((ExecutorService)this.withoutContext()).shutdownNow();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return ((ExecutorService)this.withoutContext()).submit(this.makeContextAware(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return ((ExecutorService)this.withoutContext()).submit(this.makeContextAware(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return ((ExecutorService)this.withoutContext()).submit(this.makeContextAware(task));
    }

    @Override
    public final boolean isShutdown() {
        return ((ExecutorService)this.withoutContext()).isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return ((ExecutorService)this.withoutContext()).isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.withoutContext()).awaitTermination(timeout, unit);
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return ((ExecutorService)this.withoutContext()).invokeAll(this.makeContextAware(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return ((ExecutorService)this.withoutContext()).invokeAll(this.makeContextAware(tasks), timeout, unit);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return ((ExecutorService)this.withoutContext()).invokeAny(this.makeContextAware(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return ((ExecutorService)this.withoutContext()).invokeAny(this.makeContextAware(tasks), timeout, unit);
    }

    final <T> Callable<T> makeContextAware(Callable<T> task) {
        RequestContext context = this.contextOrNull();
        if (context != null) {
            return context.makeContextAware(task);
        }
        return ArmeriaContextPropagation.captureAll().wrap(task);
    }

    private <T> Collection<? extends Callable<T>> makeContextAware(Collection<? extends Callable<T>> tasks) {
        return Objects.requireNonNull(tasks, "tasks").stream().map(this::makeContextAware).collect(ImmutableList.toImmutableList());
    }
}

