/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryDecision;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRule;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponseDuplicator;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class RetryRuleUtil {
    static final CompletableFuture<RetryDecision> NEXT_DECISION = UnmodifiableFuture.completedFuture(RetryDecision.next());
    static final CompletableFuture<RetryDecision> DEFAULT_DECISION = UnmodifiableFuture.completedFuture(RetryDecision.retry(Backoff.ofDefault()));

    static <T extends Response> RetryRule fromRetryRuleWithContent(final RetryRuleWithContent<T> retryRule) {
        return new RetryRule(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable Throwable cause) {
                return retryRule.shouldRetry(ctx, null, cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return retryRule.requiresResponseTrailers();
            }
        };
    }

    static <T extends Response> RetryRuleWithContent<T> fromRetryRule(final RetryRule retryRule) {
        return new RetryRuleWithContent<T>(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                return retryRule.shouldRetry(ctx, cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return retryRule.requiresResponseTrailers();
            }
        };
    }

    static RetryRule orElse(final RetryRule first, final RetryRule second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new RetryRule(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable Throwable cause) {
                CompletionStage<RetryDecision> decisionFuture = first.shouldRetry(ctx, cause);
                if (decisionFuture == DEFAULT_DECISION) {
                    return decisionFuture;
                }
                if (decisionFuture == NEXT_DECISION) {
                    return second.shouldRetry(ctx, cause);
                }
                return decisionFuture.thenCompose(decision -> {
                    if (decision != RetryDecision.next()) {
                        return decisionFuture;
                    }
                    return second.shouldRetry(ctx, cause);
                });
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> RetryRuleWithContent<T> orElse(final RetryRule first, final RetryRuleWithContent<T> second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new RetryRuleWithContent<T>(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();
                    RetryRuleWithContent duplicatedSecond = RetryRuleUtil.withDuplicator(second, duplicator);
                    CompletionStage decision = RetryRuleUtil.handle(ctx, response, cause, RetryRuleUtil.fromRetryRule(first), duplicatedSecond);
                    decision.handle((unused1, unused2) -> {
                        duplicator.abort();
                        return null;
                    });
                    return decision;
                }
                return RetryRuleUtil.handle(ctx, response, cause, RetryRuleUtil.fromRetryRule(first), second);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> RetryRuleWithContent<T> orElse(final RetryRuleWithContent<T> first, final RetryRule second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new RetryRuleWithContent<T>(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    try (HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();){
                        RetryRuleWithContent duplicatedFirst = RetryRuleUtil.withDuplicator(first, duplicator);
                        CompletionStage completionStage = RetryRuleUtil.handle(ctx, response, cause, duplicatedFirst, RetryRuleUtil.fromRetryRule(second));
                        return completionStage;
                    }
                }
                return RetryRuleUtil.handle(ctx, response, cause, first, RetryRuleUtil.fromRetryRule(second));
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> RetryRuleWithContent<T> orElse(final RetryRuleWithContent<T> first, final RetryRuleWithContent<T> second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new RetryRuleWithContent<T>(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();
                    RetryRuleWithContent duplicatedFirst = RetryRuleUtil.withDuplicator(first, duplicator);
                    RetryRuleWithContent duplicatedSecond = RetryRuleUtil.withDuplicator(second, duplicator);
                    CompletionStage decision = RetryRuleUtil.handle(ctx, response, cause, duplicatedFirst, duplicatedSecond);
                    decision.handle((unused1, unused2) -> {
                        duplicator.abort();
                        return null;
                    });
                    return decision;
                }
                return RetryRuleUtil.handle(ctx, response, cause, first, second);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    private static <T extends Response> CompletionStage<RetryDecision> handle(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause, RetryRuleWithContent<T> first, RetryRuleWithContent<T> second) {
        CompletionStage<RetryDecision> decisionFuture = first.shouldRetry(ctx, response, cause);
        if (decisionFuture == DEFAULT_DECISION) {
            return decisionFuture;
        }
        if (decisionFuture == NEXT_DECISION) {
            return second.shouldRetry(ctx, response, cause);
        }
        return decisionFuture.thenCompose(decision -> {
            if (decision != RetryDecision.next()) {
                return decisionFuture;
            }
            return second.shouldRetry(ctx, response, cause);
        });
    }

    private static RetryRuleWithContent<HttpResponse> withDuplicator(final RetryRuleWithContent<HttpResponse> ruleWithContent, final HttpResponseDuplicator duplicator) {
        return new RetryRuleWithContent<HttpResponse>(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable HttpResponse response, @Nullable Throwable cause) {
                return ruleWithContent.shouldRetry(ctx, duplicator.duplicate(), cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return ruleWithContent.requiresResponseTrailers();
            }
        };
    }

    private RetryRuleUtil() {
    }
}

