/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.AbstractBackoffBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RandomBackoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

@UnstableApi
public final class RandomBackoffBuilder
extends AbstractBackoffBuilder<RandomBackoffBuilder> {
    static final long DEFAULT_MIN_DELAY_MILLIS = 200L;
    static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    private long minDelayMillis = 200L;
    private long maxDelayMillis = 10000L;
    private Supplier<Random> randomSupplier = Random::new;

    RandomBackoffBuilder() {
    }

    public RandomBackoffBuilder minDelayMillis(long minDelayMillis) {
        Preconditions.checkArgument(minDelayMillis >= 0L, "minDelayMillis: %s (expected: >= 0)", minDelayMillis);
        this.minDelayMillis = minDelayMillis;
        return this;
    }

    public RandomBackoffBuilder maxDelayMillis(long maxDelayMillis) {
        Preconditions.checkArgument(maxDelayMillis >= 0L, "maxDelayMillis: %s (expected: >= 0)", maxDelayMillis);
        this.maxDelayMillis = maxDelayMillis;
        return this;
    }

    public RandomBackoffBuilder randomSupplier(Supplier<Random> randomSupplier) {
        Objects.requireNonNull(randomSupplier, "randomSupplier");
        this.randomSupplier = randomSupplier;
        return this;
    }

    @Override
    Backoff doBuild() {
        return new RandomBackoff(this.minDelayMillis, this.maxDelayMillis, this.randomSupplier);
    }
}

