/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.AbstractBackoffBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.ExponentialBackoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class ExponentialBackoffBuilder
extends AbstractBackoffBuilder<ExponentialBackoffBuilder> {
    static final long DEFAULT_INITIAL_DELAY_MILLIS = 200L;
    static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    static final double DEFAULT_MULTIPLIER = 2.0;
    private long initialDelayMillis = 200L;
    private long maxDelayMillis = 10000L;
    private double multiplier = 2.0;

    ExponentialBackoffBuilder() {
    }

    public ExponentialBackoffBuilder initialDelayMillis(long initialDelayMillis) {
        Preconditions.checkArgument(initialDelayMillis >= 0L, "initialDelayMillis: %s (expected: >= 0)", initialDelayMillis);
        this.initialDelayMillis = initialDelayMillis;
        return this;
    }

    public ExponentialBackoffBuilder maxDelayMillis(long maxDelayMillis) {
        Preconditions.checkArgument(maxDelayMillis >= 0L, "maxDelayMillis: %s (expected: >= 0)", maxDelayMillis);
        this.maxDelayMillis = maxDelayMillis;
        return this;
    }

    public ExponentialBackoffBuilder multiplier(double multiplier) {
        Preconditions.checkArgument(multiplier > 1.0, "multiplier: %s (expected: > 1.0)", (Object)multiplier);
        this.multiplier = multiplier;
        return this;
    }

    @Override
    Backoff doBuild() {
        return new ExponentialBackoff(this.initialDelayMillis, this.maxDelayMillis, this.multiplier);
    }
}

