/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.limit;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.limit.AbstractConcurrencyLimitingClient;
import io.opentelemetry.testing.internal.armeria.client.limit.ConcurrencyLimit;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntSupplier;

public final class ConcurrencyLimitingClient
extends AbstractConcurrencyLimitingClient<HttpRequest, HttpResponse>
implements HttpClient {
    public static Function<? super HttpClient, ConcurrencyLimitingClient> newDecorator(int maxConcurrency) {
        ConcurrencyLimit limit = ConcurrencyLimit.builder(maxConcurrency).build();
        return ConcurrencyLimitingClient.newDecorator(limit);
    }

    @Deprecated
    public static Function<? super HttpClient, ConcurrencyLimitingClient> newDecorator(int maxConcurrency, long timeout, TimeUnit unit) {
        ConcurrencyLimit limit = ConcurrencyLimit.builder(maxConcurrency).timeoutMillis(unit.toMillis(timeout)).build();
        return ConcurrencyLimitingClient.newDecorator(limit);
    }

    public static Function<? super HttpClient, ConcurrencyLimitingClient> newDecorator(IntSupplier maxConcurrency) {
        ConcurrencyLimit limit = ConcurrencyLimit.of(maxConcurrency);
        return ConcurrencyLimitingClient.newDecorator(limit);
    }

    @UnstableApi
    public static Function<? super HttpClient, ConcurrencyLimitingClient> newDecorator(ConcurrencyLimit concurrencyLimit) {
        Objects.requireNonNull(concurrencyLimit, "concurrencyLimit");
        return delegate -> new ConcurrencyLimitingClient((HttpClient)delegate, concurrencyLimit);
    }

    private ConcurrencyLimitingClient(HttpClient delegate, ConcurrencyLimit concurrencyLimit) {
        super(delegate, concurrencyLimit);
    }

    @Override
    protected HttpResponse newDeferredResponse(ClientRequestContext ctx, CompletionStage<HttpResponse> resFuture) throws Exception {
        return HttpResponse.of(resFuture, (EventExecutor)ctx.eventLoop());
    }
}

