/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck;

import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.PartialHealthCheckStrategy;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

final class PartialHealthCheckStrategyBuilder {
    @Nullable
    private Integer maxEndpointCount;
    @Nullable
    private Double maxEndpointRatio;

    PartialHealthCheckStrategyBuilder() {
    }

    PartialHealthCheckStrategyBuilder maxEndpointCount(int maxEndpointCount) {
        if (this.maxEndpointRatio != null) {
            throw new IllegalArgumentException("Maximum endpoint ratio is already set.");
        }
        Preconditions.checkArgument(maxEndpointCount > 0, "maxEndpointCount: %s (expected: 0 < maxEndpointCount <= MAX_INT)", maxEndpointCount);
        this.maxEndpointCount = maxEndpointCount;
        return this;
    }

    PartialHealthCheckStrategyBuilder maxEndpointRatio(double maxEndpointRatio) {
        if (this.maxEndpointCount != null) {
            throw new IllegalArgumentException("Maximum endpoint count is already set.");
        }
        Preconditions.checkArgument(maxEndpointRatio > 0.0 && maxEndpointRatio <= 1.0, "maxEndpointRatio: %s (expected: 0 < maxEndpointRatio <= 1)", (Object)maxEndpointRatio);
        this.maxEndpointRatio = maxEndpointRatio;
        return this;
    }

    PartialHealthCheckStrategy build() {
        PartialHealthCheckStrategy.EndpointLimitingFunction endpointLimitingFunction;
        if (this.maxEndpointCount != null) {
            endpointLimitingFunction = PartialHealthCheckStrategy.EndpointLimitingFunction.ofCount(this.maxEndpointCount);
        } else if (this.maxEndpointRatio != null) {
            endpointLimitingFunction = PartialHealthCheckStrategy.EndpointLimitingFunction.ofRatio(this.maxEndpointRatio);
        } else {
            throw new IllegalStateException("The maximum endpoint count or ratio must be set.");
        }
        return new PartialHealthCheckStrategy(endpointLimitingFunction);
    }
}

