/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.dns;

import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DefaultDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.resolver.ResolvedAddressTypes;

public final class DnsAddressEndpointGroupBuilder
extends DnsEndpointGroupBuilder<DnsAddressEndpointGroupBuilder> {
    private int port;
    @Nullable
    private ResolvedAddressTypes resolvedAddressTypes;

    DnsAddressEndpointGroupBuilder(String hostname) {
        super(hostname);
    }

    public DnsAddressEndpointGroupBuilder port(int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "port: %s (expected: 1...65535)", port);
        this.port = port;
        return this;
    }

    DnsAddressEndpointGroupBuilder resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
        this.resolvedAddressTypes = resolvedAddressTypes;
        return this;
    }

    public DnsAddressEndpointGroup build() {
        EventLoop eventLoop = this.getOrAcquireEventLoop();
        DefaultDnsResolver resolver = this.buildResolver(builder -> {
            if (this.resolvedAddressTypes != null) {
                builder.resolvedAddressTypes(this.resolvedAddressTypes);
            }
        }, eventLoop);
        return new DnsAddressEndpointGroup(this.selectionStrategy(), this.shouldAllowEmptyEndpoints(), this.selectionTimeoutMillis(), resolver, eventLoop, this.backoff(), this.minTtl(), this.maxTtl(), this.resolvedAddressTypes, this.hostname(), this.port, this.dnsQueryListeners());
    }
}

